/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.editor;

import cz.larkyy.aquaticcratestesting.editor.EditingPlayer;
import cz.larkyy.aquaticcratestesting.editor.EditorMenuSession;
import cz.larkyy.aquaticcratestesting.editor.inputtype.ChatInputEdit;
import cz.larkyy.aquaticcratestesting.editor.menu.MainMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.InventoryHolder;

public class EditingHandler
implements Listener {
    private final Map<UUID, EditingPlayer> editingPlayers = new HashMap<UUID, EditingPlayer>();
    private final Map<UUID, ChatInputEdit> awaitingChatInput = new HashMap<UUID, ChatInputEdit>();

    public Map<UUID, EditingPlayer> getEditingPlayers() {
        return this.editingPlayers;
    }

    public EditingPlayer getEditingPlayer(UUID uUID) {
        return this.editingPlayers.get(uUID);
    }

    public void addEditingPlayer(EditingPlayer editingPlayer) {
        this.editingPlayers.put(editingPlayer.getUuid(), editingPlayer);
    }

    public Map<UUID, ChatInputEdit> getAwaitingChatInput() {
        return this.awaitingChatInput;
    }

    public void addAwaitChatInput(UUID uUID, ChatInputEdit chatInputEdit) {
        this.awaitingChatInput.put(uUID, chatInputEdit);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (this.awaitingChatInput.containsKey(asyncPlayerChatEvent.getPlayer().getUniqueId())) {
            asyncPlayerChatEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent inventoryClickEvent) {
        InventoryHolder inventoryHolder = inventoryClickEvent.getWhoClicked().getOpenInventory().getTopInventory().getHolder();
        if (inventoryHolder instanceof EditorMenuSession) {
            EditorMenuSession editorMenuSession = (EditorMenuSession)inventoryHolder;
            editorMenuSession.onClick(inventoryClickEvent);
        }
    }

    public void openEditorMenu(Player player) {
        EditingPlayer editingPlayer = new EditingPlayer(player.getUniqueId(), null);
        new MainMenu().open(editingPlayer);
    }
}

