/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.editor;

import cz.larkyy.aquaticcratestesting.editor.EditingPlayer;
import cz.larkyy.aquaticcratestesting.editor.EditorMenu;
import cz.larkyy.aquaticcratestesting.editor.item.EditorItem;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class EditorMenuSession
implements InventoryHolder {
    private final EditorMenu editorMenu;
    private final EditingPlayer editingPlayer;
    private final Inventory inventory;
    private final Map<Integer, EditorItem> placedItems = new HashMap<Integer, EditorItem>();

    public EditorMenuSession(EditorMenu editorMenu, EditingPlayer editingPlayer) {
        this.editorMenu = editorMenu;
        this.editingPlayer = editingPlayer;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)editorMenu.getSize(), (String)editorMenu.getTitle());
        this.setupItems();
    }

    private void setupItems() {
        for (int i = 0; i < this.editorMenu.getEditorItems().size(); ++i) {
            EditorItem editorItem = this.editorMenu.getEditorItems().get(i);
            this.addPlacedItem(editorItem, i);
        }
    }

    private void addPlacedItem(EditorItem editorItem, int n) {
        this.inventory.setItem(n, editorItem.getIs(this.editingPlayer).clone());
        this.placedItems.put(n, editorItem);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getWhoClicked().getUniqueId().equals(this.editingPlayer.getUuid())) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        EditorItem editorItem = this.placedItems.get(inventoryClickEvent.getSlot());
        if (editorItem != null) {
            editorItem.click(this.editingPlayer, inventoryClickEvent);
        }
    }
}

