/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.hologram.impl;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.hologram.Hologram;
import cz.larkyy.aquaticcratestesting.nms.NMSHandler;
import cz.larkyy.aquaticcratestesting.utils.Utils;
import cz.larkyy.aquaticcratestesting.utils.colors.Colors;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Location;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AquaticHologram
extends Hologram {
    private final List<Integer> ids = new ArrayList<Integer>();
    private final List<Player> visitors = new ArrayList<Player>();
    private boolean hidden = false;

    public AquaticHologram(Location location, List<String> list) {
        super(location, list);
    }

    @Override
    public void teleport(final Location location) {
        this.setLocation(location);
        new BukkitRunnable(){

            public void run() {
                int n = AquaticHologram.this.getLines().size();
                for (Integer n2 : AquaticHologram.this.ids) {
                    AquaticHologram.this.nmsHandler().teleportEntity(n2, location.clone().add(0.0, 0.25 * (double)n, 0.0));
                    --n;
                }
            }
        }.runTask((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void move(final Location location) {
        if (Utils.isVectorSame(this.getLocation().toVector(), location.toVector())) {
            return;
        }
        this.setLocation(location);
        new BukkitRunnable(){

            public void run() {
                int n = AquaticHologram.this.getLines().size();
                for (Integer n2 : AquaticHologram.this.ids) {
                    AquaticHologram.this.nmsHandler().moveEntity(n2, location.clone().add(0.0, 0.25 * (double)n, 0.0));
                    --n;
                }
            }
        }.runTask((Plugin)AquaticCratesTesting.instance());
    }

    @Override
    public void despawn() {
        this.nmsHandler().despawnEntity(this.ids, this.visitors);
        this.visitors.clear();
        this.ids.clear();
    }

    @Override
    public void spawn(List<Player> list, Consumer<List<String>> consumer) {
        if (this.hidden) {
            this.addAllVisitors(list);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getLines());
        consumer.accept(arrayList);
        this.despawn();
        this.addAllVisitors(list);
        int n = arrayList.size();
        for (String string : arrayList) {
            this.ids.add(this.spawnLine(this.getLocation().clone().add(0.0, 0.25 * (double)n, 0.0), string));
            --n;
        }
    }

    private void addAllVisitors(List<Player> list) {
        for (Player player : list) {
            if (this.visitors.contains(player)) continue;
            this.visitors.add(player);
        }
    }

    @Override
    public void hide() {
        this.hidden = true;
        this.nmsHandler().despawnEntity(this.ids, this.visitors);
        this.ids.clear();
    }

    @Override
    public void show() {
        if (!this.hidden) {
            return;
        }
        this.hidden = false;
        this.spawn(this.visitors, list -> {});
    }

    @Override
    public void update(Consumer<List<String>> consumer) {
        int n;
        if (this.getLines() == null || this.getLines().isEmpty()) {
            this.nmsHandler().despawnEntity(this.ids, this.visitors);
            this.ids.clear();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getLines());
        consumer.accept(arrayList);
        if (this.ids.size() > arrayList.size()) {
            n = this.ids.size() - arrayList.size();
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < n; ++i) {
                arrayList2.add(this.ids.get(this.ids.size() - 1 - i));
            }
            this.nmsHandler().despawnEntity(arrayList2, this.visitors);
            this.ids.removeAll(arrayList2);
        }
        n = 0;
        for (String string : arrayList) {
            String string2 = this.visitors.isEmpty() ? string : PlaceholderAPI.setPlaceholders((Player)this.visitors.get(0), (String)string);
            Location location = this.getLocation().clone().add(0.0, 0.25 * (double)(arrayList.size() - n), 0.0);
            if (n < this.ids.size()) {
                int n2 = this.ids.get(n);
                Entity entity2 = this.nmsHandler().getEntity(n2);
                Location location2 = entity2.getLocation();
                if (!location2.getWorld().equals(location.getWorld()) || !Utils.isVectorSame(location2.toVector(), location.toVector())) {
                    this.nmsHandler().teleportEntity(n2, location);
                }
                this.nmsHandler().updateEntity(n2, entity -> entity.setCustomName(Colors.format(string2)));
            } else {
                this.ids.add(this.spawnLine(location, string2));
            }
            ++n;
        }
    }

    private int spawnLine(Location location, String string) {
        String string2 = this.visitors.isEmpty() ? string : PlaceholderAPI.setPlaceholders((Player)this.visitors.get(0), (String)string);
        return this.nmsHandler().spawnEntity(location, entity -> {
            AreaEffectCloud areaEffectCloud = (AreaEffectCloud)entity;
            areaEffectCloud.setRadius(0.0f);
            entity.setCustomName(Colors.format(string2));
            entity.setCustomNameVisible(true);
            entity.setGravity(false);
            entity.setPersistent(false);
        }, this.visitors, "area_effect_cloud");
    }

    private NMSHandler nmsHandler() {
        return AquaticCratesTesting.getNmsHandler();
    }
}

