/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.loader;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.loader.impl.ItemsAdderLoader;
import cz.larkyy.aquaticcratestesting.nms.Loader;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LoaderManager {
    private final List<Loader> loaders = new ArrayList<Loader>();
    private final Runnable runnable;

    public LoaderManager(Runnable runnable) {
        this.runnable = runnable;
        if (this.getPlugin("ItemsAdder") != null) {
            this.loaders.add(new ItemsAdderLoader(this::tryLoad));
            if (AquaticCratesTesting.loaded) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"iareload");
            }
        }
        if (AquaticCratesTesting.getModelEngineAdapter() != null) {
            Loader loader = AquaticCratesTesting.getModelEngineAdapter().createMEGLoader(AquaticCratesTesting.instance(), this::tryLoad);
            this.loaders.add(loader);
            if (AquaticCratesTesting.loaded) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"meg reload");
            }
        }
        if (this.loaders.isEmpty()) {
            this.tryLoad();
        }
    }

    public void tryLoad() {
        for (Loader loader : this.loaders) {
            if (loader.isLoaded()) continue;
            return;
        }
        this.load();
    }

    private void load() {
        this.runnable.run();
    }

    private Plugin getPlugin(String string) {
        return AquaticCratesTesting.instance().getServer().getPluginManager().getPlugin(string);
    }
}

