/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.player;

import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.api.events.KeyUseEvent;
import cz.larkyy.aquaticcratestesting.crate.Key;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class CratePlayer {
    private final Player player;
    private final Map<String, Integer> virtualKeys;

    public CratePlayer(Player player) {
        this.player = player;
        this.virtualKeys = new HashMap<String, Integer>();
    }

    public int getKeys(String string) {
        return this.virtualKeys.getOrDefault(string, 0);
    }

    public Map<String, Integer> getVirtualKeys() {
        return this.virtualKeys;
    }

    public void addKeys(String string, int n) {
        int n2 = this.getKeys(string);
        this.virtualKeys.put(string, n2 + n);
    }

    public boolean takeKey(String string) {
        Key key = Key.get(string);
        if (key == null) {
            return false;
        }
        return this.takeKey(key);
    }

    public boolean takeKey(Key key) {
        if (this.takePhysicalKey(key)) {
            return true;
        }
        return this.takeVirtualKey(key);
    }

    public void takeKeys(String string, int n) {
        if (!this.virtualKeys.containsKey(string)) {
            return;
        }
        int n2 = this.virtualKeys.get(string);
        if ((n2 -= n) < 0) {
            n2 = 0;
        }
        this.virtualKeys.put(string, n2);
    }

    private boolean takePhysicalKey(Key key) {
        for (ItemStack itemStack : this.player.getInventory().getContents()) {
            if (itemStack == null || !key.isItemKey(itemStack)) continue;
            itemStack.setAmount(itemStack.getAmount() - 1);
            KeyUseEvent keyUseEvent = new KeyUseEvent(this.player.getPlayer(), key.getCrate(), KeyUseEvent.KeyType.PHYSICAL, itemStack);
            Bukkit.getPluginManager().callEvent((Event)keyUseEvent);
            return true;
        }
        return false;
    }

    public boolean hasKey(Key key, int n) {
        int n2 = this.getKeys(key.getIdentifier());
        if (n2 >= n) {
            return true;
        }
        for (ItemStack itemStack : this.player.getInventory().getContents()) {
            if (itemStack == null || !key.isItemKey(itemStack) || itemStack.getAmount() < n) continue;
            return true;
        }
        return false;
    }

    private boolean takeVirtualKey(Key key) {
        int n = this.getKeys(key.getIdentifier());
        if (n < 1) {
            return false;
        }
        this.virtualKeys.put(key.getIdentifier(), n - 1);
        KeyUseEvent keyUseEvent = new KeyUseEvent(this.player.getPlayer(), key.getCrate(), KeyUseEvent.KeyType.VIRTUAL, null);
        Bukkit.getPluginManager().callEvent((Event)keyUseEvent);
        return true;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isInAnimation() {
        return AquaticCratesAPI.getPlayerHandler().isInAnimation(this.player);
    }

    public static CratePlayer get(Player player) {
        return AquaticCratesAPI.getPlayer(player);
    }
}

