/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.addons;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.Utils;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Citizens {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private AuctionData auctionData = new AuctionData();
    public static NPC npc;

    public void spawnNPC() {
        this.destoryBuggyNPCs(this.auctionData.getNPCSpawnLocation().add(0.5, 0.0, 0.5));
        NPCRegistry nPCRegistry = CitizensAPI.getNPCRegistry();
        npc = nPCRegistry.createNPC(EntityType.PLAYER, Utils.colorize(ConfigValues.npc_name));
        SkinTrait skinTrait = (SkinTrait)npc.getTrait(SkinTrait.class);
        skinTrait.setSkinName(ConfigValues.npc_skin);
        if (ConfigValues.npc_look_nearby) {
            LookClose lookClose = (LookClose)npc.getTrait(LookClose.class);
            lookClose.lookClose(true);
            lookClose.setRealisticLooking(true);
        }
        npc.spawn(this.auctionData.getNPCSpawnLocation().add(0.5, 0.0, 0.5));
    }

    public void teleportNPC() {
        this.destoryBuggyNPCs(this.auctionData.getNPCTeleportLocation().add(0.5, 0.0, 0.5));
        npc.teleport(this.auctionData.getNPCTeleportLocation().add(0.5, 0.0, 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void despawnNPC() {
        if (npc != null) {
            npc.destroy();
            npc = null;
        }
    }

    public void despawnNPC(NPC nPC) {
        if (nPC != null) {
            nPC.destroy();
        }
    }

    public void destoryBuggyNPCs(Location location) {
        location.getWorld().getNearbyEntities(location, 1.0, 2.0, 1.0).forEach(entity -> {
            NPC nPC;
            if (CitizensAPI.getNPCRegistry().isNPC(entity) && (nPC = CitizensAPI.getNPCRegistry().getNPC(entity)).getName().equalsIgnoreCase(Utils.colorize(ConfigValues.npc_name))) {
                this.despawnNPC(nPC);
            }
        });
    }
}

