/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class AuctionData {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private File file = new File(this.auctioneer.getDataFolder() + "/", "data.yml");
    private FileConfiguration data = YamlConfiguration.loadConfiguration((File)this.file);

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public void save() {
        try {
            this.data.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setDisplayLocation(Location location) {
        if (this.getDisplayLocation() != null) {
            this.getDisplayLocation().getWorld().getNearbyEntities(this.getDisplayLocation(), 3.0, 5.0, 3.0).forEach(entity -> {
                ArmorStand armorStand;
                if (entity instanceof ArmorStand && (armorStand = (ArmorStand)entity).getName().equalsIgnoreCase("auctioneer")) {
                    armorStand.remove();
                }
            });
        }
        this.data.set("display-location.world", (Object)location.getWorld().getName());
        this.data.set("display-location.x", (Object)location.getX());
        this.data.set("display-location.y", (Object)location.getY());
        this.data.set("display-location.z", (Object)location.getZ());
        this.save();
        location.getBlock().setType(XMaterial.AIR.parseMaterial());
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(this.getDisplayLocation().add(0.5, -1.37, 0.5), EntityType.ARMOR_STAND);
        armorStand.setCustomName("auctioneer");
        armorStand.setCustomNameVisible(false);
        armorStand.setHelmet(new ItemStack(XMaterial.GLASS.parseMaterial(), 1));
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        this.data.set("display-location.id", (Object)armorStand.getUniqueId().toString());
        this.save();
    }

    public Location getDisplayLocation() {
        String string = "null";
        int n = 0;
        int n2 = 100;
        int n3 = 0;
        if (this.data.isSet("display-location")) {
            if (this.data.isSet("display-location.world")) {
                string = this.data.getString("display-location.world");
            }
            if (this.data.isSet("display-location.x")) {
                n = this.data.getInt("display-location.x");
            }
            if (this.data.isSet("display-location.y")) {
                n2 = this.data.getInt("display-location.y");
            }
            if (this.data.isSet("display-location.z")) {
                n3 = this.data.getInt("display-location.z");
            }
        }
        if (string.equals("null")) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)string), (double)n, (double)n2, (double)n3);
    }

    public UUID getDisplayID() {
        if (this.data.isSet("display-location.id")) {
            return UUID.fromString(this.data.getString("display-location.id"));
        }
        return null;
    }

    public void setNPCSpawnLocation(Location location) {
        this.data.set("npc.spawn-location.world", (Object)location.getWorld().getName());
        this.data.set("npc.spawn-location.x", (Object)location.getBlockX());
        this.data.set("npc.spawn-location.y", (Object)location.getBlockY());
        this.data.set("npc.spawn-location.z", (Object)location.getBlockZ());
        this.data.set("npc.spawn-location.yaw", (Object)Float.valueOf(location.getYaw()));
        this.data.set("npc.spawn-location.pitch", (Object)Float.valueOf(location.getPitch()));
        this.save();
    }

    public Location getNPCSpawnLocation() {
        String string = "null";
        int n = 0;
        int n2 = 100;
        int n3 = 0;
        float f = -90.0f;
        float f2 = 1.9f;
        if (this.data.isSet("npc.spawn-location")) {
            if (this.data.isSet("npc.spawn-location.world")) {
                string = this.data.getString("npc.spawn-location.world");
            }
            if (this.data.isSet("npc.spawn-location.x")) {
                n = this.data.getInt("npc.spawn-location.x");
            }
            if (this.data.isSet("npc.spawn-location.y")) {
                n2 = this.data.getInt("npc.spawn-location.y");
            }
            if (this.data.isSet("npc.spawn-location.z")) {
                n3 = this.data.getInt("npc.spawn-location.z");
            }
            if (this.data.isSet("npc.spawn-location.yaw")) {
                f = (float)this.data.getDouble("npc.spawn-location.yaw");
            }
            if (this.data.isSet("npc.spawn-location.pitch")) {
                f2 = (float)this.data.getDouble("npc.spawn-location.pitch");
            }
        }
        if (string.equals("null")) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)string), (double)n, (double)n2, (double)n3, f, f2);
    }

    public void setNPCTeleportLocation(Location location) {
        this.data.set("npc.teleport-location.world", (Object)location.getWorld().getName());
        this.data.set("npc.teleport-location.x", (Object)location.getBlockX());
        this.data.set("npc.teleport-location.y", (Object)location.getBlockY());
        this.data.set("npc.teleport-location.z", (Object)location.getBlockZ());
        this.data.set("npc.teleport-location.yaw", (Object)Float.valueOf(location.getYaw()));
        this.data.set("npc.teleport-location.pitch", (Object)Float.valueOf(location.getPitch()));
        this.save();
    }

    public Location getNPCTeleportLocation() {
        String string = "null";
        int n = 0;
        int n2 = 100;
        int n3 = 0;
        float f = -90.0f;
        float f2 = 1.9f;
        if (this.data.isSet("npc.teleport-location")) {
            if (this.data.isSet("npc.teleport-location.world")) {
                string = this.data.getString("npc.teleport-location.world");
            }
            if (this.data.isSet("npc.teleport-location.x")) {
                n = this.data.getInt("npc.teleport-location.x");
            }
            if (this.data.isSet("npc.teleport-location.y")) {
                n2 = this.data.getInt("npc.teleport-location.y");
            }
            if (this.data.isSet("npc.teleport-location.z")) {
                n3 = this.data.getInt("npc.teleport-location.z");
            }
            if (this.data.isSet("npc.teleport-location.yaw")) {
                f = (float)this.data.getDouble("npc.teleport-location.yaw");
            }
            if (this.data.isSet("npc.teleport-location.pitch")) {
                f2 = (float)this.data.getDouble("npc.teleport-location.pitch");
            }
        }
        if (string.equals("null")) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)string), (double)n, (double)n2, (double)n3, f, f2);
    }

    public void setPlayerTeleportLocation(Location location) {
        this.data.set("player.teleport-location.world", (Object)location.getWorld().getName());
        this.data.set("player.teleport-location.x", (Object)location.getBlockX());
        this.data.set("player.teleport-location.y", (Object)location.getBlockY());
        this.data.set("player.teleport-location.z", (Object)location.getBlockZ());
        this.data.set("player.teleport-location.yaw", (Object)Float.valueOf(location.getYaw()));
        this.data.set("player.teleport-location.pitch", (Object)Float.valueOf(location.getPitch()));
        this.save();
    }

    public Location getPlayerTeleportLocation() {
        String string = null;
        int n = 0;
        int n2 = 100;
        int n3 = 0;
        float f = -90.0f;
        float f2 = 1.9f;
        if (this.data.isSet("player.teleport-location")) {
            if (this.data.isSet("player.teleport-location.world")) {
                string = this.data.getString("player.teleport-location.world");
            }
            if (this.data.isSet("player.teleport-location.x")) {
                n = this.data.getInt("player.teleport-location.x");
            }
            if (this.data.isSet("player.teleport-location.y")) {
                n2 = this.data.getInt("player.teleport-location.y");
            }
            if (this.data.isSet("player.teleport-location.z")) {
                n3 = this.data.getInt("player.teleport-location.z");
            }
            if (this.data.isSet("player.teleport-location.yaw")) {
                f = (float)this.data.getDouble("player.teleport-location.yaw");
            }
            if (this.data.isSet("player.teleport-location.pitch")) {
                f2 = (float)this.data.getDouble("player.teleport-location.pitch");
            }
        }
        if (string == null) {
            return null;
        }
        return new Location(Bukkit.getWorld(string), (double)n, (double)n2, (double)n3, f, f2);
    }

    public List<String> getLoggedOutCache() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.data.isSet("logout-cache")) {
            this.data.getStringList("logout-cache").forEach(string -> arrayList.add((String)string));
        }
        return arrayList;
    }

    public void removeLoggedOutCache(UUID uUID) {
        List<String> list = this.getLoggedOutCache();
        if (list.contains(uUID.toString())) {
            list.remove(uUID.toString());
            this.data.set("logout-cache", list);
            this.save();
        }
    }

    public List<Integer> getRewardFromCache(UUID uUID) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.data.isSet("reward-cache." + uUID.toString())) {
            this.data.getIntegerList("reward-cache." + uUID).forEach(n -> arrayList.add((Integer)n));
        }
        return arrayList;
    }

    public void addRewardToCache(UUID uUID, AuctionItem auctionItem) {
        List<Integer> list = this.getRewardFromCache(uUID);
        list.add(auctionItem.getID());
        this.data.set("reward-cache." + uUID, list);
        this.save();
    }

    public void removeRewardFromCache(UUID uUID, AuctionItem auctionItem) {
        List<Integer> list = this.getRewardFromCache(uUID);
        if (list.contains(auctionItem.getID())) {
            list.remove((Object)auctionItem.getID());
            this.data.set("reward-cache." + uUID, list);
            this.save();
        }
    }
}

