/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RewardData {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private File file = new File(this.auctioneer.getDataFolder() + "/", "rewards.yml");
    private FileConfiguration data = YamlConfiguration.loadConfiguration((File)this.file);

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public void save() {
        try {
            this.data.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void moveOldData() {
        AuctionData auctionData = new AuctionData();
        FileConfiguration fileConfiguration = auctionData.getData();
        if (fileConfiguration.contains("auction-items")) {
            Object object = fileConfiguration.get("auction-items");
            this.data.set("auction-items", object);
            this.save();
            fileConfiguration.set("auction-items", null);
            auctionData.save();
            Bukkit.getLogger().info("Reward data from data.yml moved to rewards.yml successfully.");
        }
    }

    public List<AuctionItem> getAuctionItems() {
        ArrayList<AuctionItem> arrayList = new ArrayList<AuctionItem>();
        if (this.data.isSet("auction-items")) {
            for (String string : this.data.getConfigurationSection("auction-items").getKeys(false)) {
                int n = Integer.valueOf(string);
                arrayList.add(new AuctionItem(n));
            }
            return arrayList;
        }
        return arrayList;
    }
}

