/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.handlers;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.addons.CMIHolograms;
import com.github.rossrao.auctioneer.addons.Citizens;
import com.github.rossrao.auctioneer.addons.HolographicDisplays;
import com.github.rossrao.auctioneer.api.events.AuctionEndEvent;
import com.github.rossrao.auctioneer.api.events.AuctionJoinEvent;
import com.github.rossrao.auctioneer.api.events.AuctionStartEvent;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.RewardData;
import com.github.rossrao.auctioneer.auction.animations.DiscoBall;
import com.github.rossrao.auctioneer.auction.animations.Fireworks;
import com.github.rossrao.auctioneer.auction.handlers.RewardHandler;
import com.github.rossrao.auctioneer.auction.handlers.TimeHandler;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.auction.listeners.AsyncChatListener;
import com.github.rossrao.auctioneer.auction.menus.RewardCollectorUI;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.enums.BidType;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class AuctionHandler {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private static AuctionData auctionData;
    private static RewardData rewardData;
    public static double totalMoney;
    public static boolean active;
    public static AtomicBoolean auctionOpen;
    static List<Player> participants;
    static HashMap<UUID, Location> teleportCache;
    static List<Integer> previousItems;
    public static UUID lastBidder;
    public static AuctionItem currentItem;
    public static double baseCost;
    public static double previousCost;
    public static double currentCost;
    public static double nextOffer;
    static BukkitTask bidTask;
    static BukkitTask itemTask;
    static BukkitTask newItemTask;
    static BukkitTask timerItemTask;
    static AtomicInteger auctions;
    public static AtomicInteger timer;
    static Item displayItem;
    static double increment;
    public static boolean offerMade;
    public static String itemName;
    public static boolean hasABid;
    public static AtomicInteger counter;
    public static boolean menuAvailable;
    private static List<OfflinePlayer> winners;
    private static List<Integer> winnersItems;
    private static List<Double> winnersCoins;

    public AuctionHandler() {
        auctionData = new AuctionData();
        rewardData = new RewardData();
        increment = ConfigValues.exponential_increment_enabled ? (double)ConfigValues.default_exponential_increment / 100.0 : (double)ConfigValues.increment / 100.0;
        timer.set(ConfigValues.bid_end);
        offerMade = false;
        hasABid = false;
        menuAvailable = false;
        totalMoney = 0.0;
        AuctionHandler.setNextItem();
        itemTask = this.auctioneer.getServer().getScheduler().runTaskTimer((Plugin)this.auctioneer, () -> {
            if (auctionOpen.get() && (displayItem == null || displayItem.isDead())) {
                Location location = auctionData.getDisplayLocation();
                if (currentItem == null) {
                    AuctionHandler.setNextItem();
                }
                displayItem = location.getWorld().dropItem(location.add(0.5, 1.5, 0.5), currentItem.getItemStack(true));
                displayItem.setPickupDelay(Integer.MAX_VALUE);
                displayItem.setVelocity(new Vector(0, -1, 0));
            }
        }, 20L, 20L);
    }

    public static void cancelTasks() {
        if (bidTask != null) {
            bidTask.cancel();
        }
        if (itemTask != null) {
            itemTask.cancel();
        }
        if (newItemTask != null) {
            newItemTask.cancel();
        }
        if (timerItemTask != null) {
            timerItemTask.cancel();
        }
        if (DiscoBall.colorSwitcherTask != null) {
            DiscoBall.colorSwitcherTask.cancel();
        }
    }

    public void start() {
        active = true;
        counter.set(0);
        if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
            new Citizens().spawnNPC();
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            ConfigValues.auction_starting.forEach(string -> player.sendMessage(Utils.colorize(string)));
            if (ConfigValues.auction_starting_sound_enabled) {
                player.playSound(player.getLocation(), ConfigValues.auction_starting_sound, 1.0f, 1.0f);
            }
        });
        final int n = ConfigValues.join_time * 60;
        new BukkitRunnable(){

            public void run() {
                counter.set(counter.get() + 1);
                if (counter.get() == n || participants.size() >= ConfigValues.max_players) {
                    this.cancel();
                    active = false;
                    if (participants.size() < ConfigValues.min_players) {
                        AuctionHandler.this.reset();
                        return;
                    }
                    AuctionHandler.this.sendAuctionStartMessage();
                }
            }
        }.runTaskTimer((Plugin)this.auctioneer, 0L, 20L);
    }

    public void sendAuctionStartMessage() {
        if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
            new Citizens().teleportNPC();
        }
        participants.forEach(player -> {
            ConfigValues.auction_welcome.forEach(string -> player.sendMessage(Utils.colorize(string)));
            if (ConfigValues.auction_welcome_sound_enabled) {
                player.playSound(player.getLocation(), ConfigValues.auction_welcome_sound, 1.0f, 1.0f);
            }
        });
        if (ConfigValues.auction_instructions_enabled) {
            participants.forEach(player -> ConfigValues.auction_instructions.forEach(string -> player.sendMessage(Utils.colorize(string))));
        }
        this.auctioneer.getServer().getScheduler().runTaskLater((Plugin)this.auctioneer, () -> {
            this.startAuction();
            if (ConfigValues.music_enabled) {
                participants.forEach(player -> player.playSound(player.getLocation(), ConfigValues.music, 1.0f, 1.0f));
            }
            participants.forEach(player -> AuctionHandler.hideParticipants(player));
            AuctionStartEvent auctionStartEvent = new AuctionStartEvent();
            Bukkit.getPluginManager().callEvent((Event)auctionStartEvent);
        }, (long)(20 * ConfigValues.auction_start_time));
    }

    public static void placeBid(Player player) {
        if (!hasABid) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Auctioneer.getInstance(), () -> {
                if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                    new HolographicDisplays().createBidHologram();
                }
                if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                    new CMIHolograms().createBidHologram();
                }
                hasABid = true;
            }, 1L);
        }
        AuctionHandler.resetTimer();
        if (nextOffer > 0.0) {
            currentCost = nextOffer;
        }
        lastBidder = player.getUniqueId();
        participants.forEach(player2 -> {
            player2.sendMessage(Utils.colorize(ConfigValues.auction_bid.replace("%player_display%", player.getDisplayName()).replace("%player%", player.getName()).replace("%coins%", Utils.formatDouble(currentCost)).replace("%item%", itemName)));
            if (ConfigValues.auction_bid_sound_enabled) {
                player2.playSound(player2.getLocation(), ConfigValues.auction_bid_sound, 1.0f, 1.0f);
            }
        });
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)Auctioneer.getInstance(), () -> {
            nextOffer = AuctionHandler.increaseCostAndGet();
            AuctionHandler.makeOffer(nextOffer);
            AsyncChatListener.bidPlaced = false;
        }, (long)(20 * ConfigValues.new_offer_time));
    }

    public static void placeMenuBid(Player player, double d) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Auctioneer.getInstance(), () -> {
            if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                new HolographicDisplays().createBidHologram();
            }
            if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                new CMIHolograms().createBidHologram();
            }
        }, 1L);
        AuctionHandler.resetTimer();
        currentCost = d;
        lastBidder = player.getUniqueId();
        participants.forEach(player2 -> {
            player2.sendMessage(Utils.colorize(ConfigValues.auction_bid.replace("%player_display%", player.getDisplayName()).replace("%player%", player.getName()).replace("%coins%", Utils.formatDouble(d)).replace("%item%", itemName)));
            if (ConfigValues.auction_bid_sound_enabled) {
                player2.playSound(player2.getLocation(), ConfigValues.auction_bid_sound, 1.0f, 1.0f);
            }
        });
    }

    public void startAuction() {
        if (auctions.get() == ConfigValues.max_items || currentItem == null) {
            AuctionHandler.end();
            return;
        }
        auctions.set(auctions.get() + 1);
        AuctionHandler.resetTimer();
        auctionOpen.set(true);
        hasABid = false;
        if (ConfigValues.bidding_type == BidType.MENU) {
            menuAvailable = true;
        }
        if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
            new HolographicDisplays().createInitialHologram();
        }
        if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
            new CMIHolograms().createInitialHologram();
        }
        if (ConfigValues.bidding_type == BidType.CHAT) {
            currentCost = AuctionHandler.increaseCostAndGet();
        }
        participants.forEach(player -> {
            if (auctions.get() == 1) {
                player.sendMessage(Utils.colorize(ConfigValues.first_auction.replace("%coins%", Utils.formatDouble(currentItem.getBaseCost())).replace("%item%", itemName)));
            } else {
                player.sendMessage(Utils.colorize(ConfigValues.next_auction.replace("%coins%", Utils.formatDouble(currentItem.getBaseCost())).replace("%item%", itemName)));
            }
            if (ConfigValues.new_auction_sound_enabled) {
                player.playSound(player.getLocation(), ConfigValues.new_auction_sound, 1.0f, 1.0f);
            }
        });
        offerMade = true;
        bidTask = this.auctioneer.getServer().getScheduler().runTaskTimer((Plugin)this.auctioneer, () -> {
            if (timer.get() == 4) {
                participants.forEach(player -> {
                    player.sendMessage(Utils.colorize(ConfigValues.countdown_going_once));
                    if (ConfigValues.countdown_sound_enabled) {
                        player.playSound(player.getLocation(), ConfigValues.countdown_sound, 1.0f, 1.0f);
                    }
                });
            } else if (timer.get() == 2) {
                participants.forEach(player -> {
                    player.sendMessage(Utils.colorize(ConfigValues.countdown_going_twice));
                    if (ConfigValues.countdown_sound_enabled) {
                        player.playSound(player.getLocation(), ConfigValues.countdown_sound, 1.0f, 1.0f);
                    }
                });
            } else if (timer.get() == 1) {
                if (ConfigValues.bidding_type == BidType.MENU) {
                    participants.forEach(HumanEntity::closeInventory);
                    menuAvailable = false;
                }
            } else if (timer.get() == 0) {
                String string;
                bidTask.cancel();
                if (ConfigValues.bidding_type == BidType.MENU) {
                    this.auctioneer.getBidUI().nextPage();
                }
                previousItems.add(currentItem.getID());
                if (lastBidder == null) {
                    if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                        new HolographicDisplays().createNoBiddersHologram();
                    }
                    if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                        new CMIHolograms().createNoBiddersHologram();
                    }
                    participants.forEach(player -> player.sendMessage(Utils.colorize(ConfigValues.no_bids.replace("%item%", itemName))));
                    newItemTask = Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.auctioneer, () -> {
                        AuctionHandler.setNextItem();
                        if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                            new HolographicDisplays().deleteHologram();
                        }
                        if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                            new CMIHolograms().deleteHologram();
                        }
                        displayItem.remove();
                        participants.forEach(HumanEntity::closeInventory);
                        this.startAuction();
                    }, (long)(20 * ConfigValues.new_item_time));
                    return;
                }
                OfflinePlayer offlinePlayer = this.auctioneer.getServer().getOfflinePlayer(lastBidder);
                if (!offlinePlayer.isOnline()) {
                    string = this.auctioneer.getServer().getOfflinePlayer(lastBidder).getName();
                } else {
                    Player player2 = (Player)offlinePlayer;
                    string = player2.getDisplayName();
                }
                if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                    new HolographicDisplays().createSoldHologram();
                }
                if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                    new CMIHolograms().createSoldHologram();
                }
                if (ConfigValues.animations_disco_ball_enabled) {
                    new DiscoBall().playAnimation();
                }
                if (offlinePlayer.isOnline() && ConfigValues.animations_fireworks_enabled) {
                    new Fireworks().playAnimation(offlinePlayer.getPlayer());
                }
                totalMoney += currentCost;
                new RewardHandler(currentItem).giveReward(offlinePlayer, currentCost);
                winners.add(offlinePlayer);
                winnersItems.add(currentItem.getID());
                winnersCoins.add(currentCost);
                participants.forEach(player -> {
                    player.sendMessage(Utils.colorize(ConfigValues.sold.replace("%player_display%", string).replace("%player%", offlinePlayer.getName()).replace("%coins%", Utils.formatDouble(currentCost)).replace("%item%", itemName)));
                    if (ConfigValues.sold_sound_enabled) {
                        player.playSound(player.getLocation(), ConfigValues.sold_sound, 1.0f, 1.0f);
                    }
                });
                offerMade = false;
                newItemTask = Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.auctioneer, () -> {
                    if (ConfigValues.animations_disco_ball_enabled) {
                        new DiscoBall().stopAnimation();
                    }
                    lastBidder = null;
                    if (timerItemTask != null) {
                        timerItemTask.cancel();
                    }
                    if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
                        new HolographicDisplays().deleteHologram();
                    }
                    if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
                        new CMIHolograms().deleteHologram();
                    }
                    AuctionHandler.setNextItem();
                    displayItem.remove();
                    participants.forEach(HumanEntity::closeInventory);
                    this.startAuction();
                }, (long)(20 * ConfigValues.new_item_time));
            }
            timer.set(timer.get() - 1);
        }, 0L, 20L);
        if (ConfigValues.bidding_type == BidType.MENU) {
            timerItemTask = this.auctioneer.getServer().getScheduler().runTaskTimer((Plugin)this.auctioneer, () -> this.auctioneer.getBidUI().getInventory().setItem(ConfigValues.bid_menu_timer_slot, this.getTimerItem()), 0L, 5L);
        }
    }

    public static void resetTimer() {
        timer.set(ConfigValues.bid_end);
    }

    public static void addParticipant(Player player) {
        player.closeInventory();
        if (!active) {
            player.sendMessage(Utils.colorize(ConfigValues.no_auction));
            return;
        }
        if (ConfigValues.join_permission_enabled && !player.hasPermission(ConfigValues.join_permission)) {
            player.sendMessage(Utils.colorize(ConfigValues.no_join_permission));
            return;
        }
        if (AuctionHandler.isParticipant(player)) {
            player.sendMessage(Utils.colorize(ConfigValues.already_at_auction));
            return;
        }
        if (Auctioneer.getEconomy().getBalance((OfflinePlayer)player) < ConfigValues.join_money_requirement) {
            player.sendMessage(Utils.colorize(ConfigValues.not_enough_requirement_money));
            if (ConfigValues.not_enough_requirement_money_sound_enabled) {
                player.playSound(player.getLocation(), ConfigValues.not_enough_requirement_money_sound, 1.0f, 1.0f);
            }
            return;
        }
        teleportCache.put(player.getUniqueId(), player.getLocation());
        participants.add(player);
        player.teleport(auctionData.getPlayerTeleportLocation());
        if (ConfigValues.join_money_requirement > 0.0) {
            Auctioneer.getInstance();
            Auctioneer.getEconomy().withdrawPlayer((OfflinePlayer)player, ConfigValues.join_money_requirement);
        }
        participants.forEach(player2 -> {
            player2.sendMessage(Utils.colorize(ConfigValues.joined_auction.replace("%player_display%", player.getDisplayName()).replace("%player%", player.getName()).replace("%participants%", String.valueOf(participants.size())).replace("%max_participants%", String.valueOf(ConfigValues.max_players))));
            if (ConfigValues.joined_sound_enabled) {
                player2.playSound(player2.getLocation(), ConfigValues.joined_sound, 0.5f, 1.0f);
            }
        });
        AuctionJoinEvent auctionJoinEvent = new AuctionJoinEvent(player);
        Bukkit.getPluginManager().callEvent((Event)auctionJoinEvent);
    }

    public static void removeParticipant(Player player) {
        if (participants.contains(player)) {
            participants.remove(player);
            player.teleport(teleportCache.get(player.getUniqueId()));
            if (ConfigValues.music_enabled) {
                player.stopSound(ConfigValues.music);
            }
        }
    }

    public static boolean isParticipant(Player player) {
        return participants.contains(player);
    }

    public void reset() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(Utils.colorize(ConfigValues.min_players_message));
        }
        for (Player player : participants) {
            Auctioneer.getInstance();
            Auctioneer.getEconomy().depositPlayer((OfflinePlayer)player, ConfigValues.join_money_requirement);
            player.teleport(teleportCache.get(player.getUniqueId()));
        }
        participants.clear();
        if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
            new Citizens().despawnNPC();
        }
    }

    public static void end() {
        if (ConfigValues.distribute_enabled) {
            double d = totalMoney - (double)Math.round((double)ConfigValues.distribute_fee * 100.0 / totalMoney);
            double d2 = d / (double)participants.size();
            participants.forEach(player -> {
                Auctioneer.getEconomy().depositPlayer((OfflinePlayer)player, d2);
                player.sendMessage(Utils.colorize(ConfigValues.distribute_message.replace("%total%", Utils.formatDouble(totalMoney)).replace("%participants%", String.valueOf(participants.size())).replace("%coins%", Utils.formatDouble(d2))));
            });
            totalMoney = 0.0;
        }
        auctions.set(0);
        auctionOpen.set(false);
        if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
            new Citizens().despawnNPC();
        }
        AuctionEndEvent auctionEndEvent = new AuctionEndEvent(winners, winnersItems, winnersCoins, participants, new TimeHandler().getTimeTillStart());
        Bukkit.getPluginManager().callEvent((Event)auctionEndEvent);
        winners.clear();
        winnersItems.clear();
        winnersCoins.clear();
        for (Player player2 : participants) {
            AuctionHandler.showParticipants(player2);
            if (ConfigValues.music_enabled) {
                player2.stopSound(ConfigValues.music);
            }
            player2.sendMessage(Utils.colorize(ConfigValues.auction_ended));
            player2.teleport(teleportCache.get(player2.getUniqueId()));
            if (ConfigValues.auction_ended_sound_enabled) {
                player2.playSound(player2.getLocation(), ConfigValues.auction_ended_sound, 1.0f, 1.0f);
            }
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)Auctioneer.getInstance(), () -> {
                if (!auctionData.getRewardFromCache(player2.getUniqueId()).isEmpty()) {
                    player2.openInventory(new RewardCollectorUI(Auctioneer.getInstance()).open(player2));
                }
            }, 20L);
        }
        participants.clear();
        previousItems.clear();
        menuAvailable = false;
        lastBidder = null;
        timer.set(15);
        AuctionHandler.setNextItem();
    }

    public static void forceEnd() {
        if (ConfigValues.distribute_enabled) {
            double d = totalMoney - (double)Math.round((double)ConfigValues.distribute_fee * 100.0 / totalMoney);
            double d2 = d / (double)participants.size();
            participants.forEach(player -> {
                Auctioneer.getEconomy().depositPlayer((OfflinePlayer)player, d2);
                player.sendMessage(Utils.colorize(ConfigValues.distribute_message.replace("%total%", Utils.formatDouble(totalMoney)).replace("%participants%", String.valueOf(participants.size())).replace("%coins%", Utils.formatDouble(d2))));
            });
            totalMoney = 0.0;
        }
        AuctionHandler.cancelTasks();
        auctions.set(0);
        auctionOpen.set(false);
        active = false;
        if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
            new Citizens().despawnNPC();
        }
        AuctionEndEvent auctionEndEvent = new AuctionEndEvent(winners, winnersItems, winnersCoins, participants, new TimeHandler().getTimeTillStart());
        Bukkit.getPluginManager().callEvent((Event)auctionEndEvent);
        winners.clear();
        winnersItems.clear();
        winnersCoins.clear();
        for (Player player2 : participants) {
            AuctionHandler.showParticipants(player2);
            if (ConfigValues.music_enabled) {
                player2.stopSound(ConfigValues.music);
            }
            player2.sendMessage(Utils.colorize(ConfigValues.auction_ended));
            player2.teleport(teleportCache.get(player2.getUniqueId()));
            if (ConfigValues.auction_ended_sound_enabled) {
                player2.playSound(player2.getLocation(), ConfigValues.auction_ended_sound, 1.0f, 1.0f);
            }
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)Auctioneer.getInstance(), () -> {
                if (!auctionData.getRewardFromCache(player2.getUniqueId()).isEmpty()) {
                    player2.openInventory(new RewardCollectorUI(Auctioneer.getInstance()).open(player2));
                }
            }, 20L);
        }
        participants.clear();
        previousItems.clear();
        if (displayItem != null) {
            displayItem.remove();
        }
        if (Auctioneer.isHolographicDisplaysEnabled() && ConfigValues.holograms_enabled) {
            new HolographicDisplays().deleteHologram();
        }
        if (Auctioneer.isCmiHologramsEnabled() && ConfigValues.holograms_enabled) {
            new CMIHolograms().deleteHologram();
        }
        menuAvailable = false;
        lastBidder = null;
        timer.set(15);
        AuctionHandler.setNextItem();
    }

    public static void setNextItem() {
        List<AuctionItem> list = rewardData.getAuctionItems();
        currentItem = null;
        itemName = null;
        if (previousItems.size() == list.size()) {
            return;
        }
        while (currentItem == null) {
            AuctionItem auctionItem = list.get(ThreadLocalRandom.current().nextInt(list.size()));
            if (previousItems.contains(auctionItem.getID())) continue;
            currentItem = auctionItem;
        }
        if (ConfigValues.exponential_increment_enabled) {
            increment = (double)ConfigValues.default_exponential_increment / 100.0;
        }
        itemName = currentItem.getDisplayName();
        baseCost = currentItem.getBaseCost();
        currentCost = 0.0;
        previousCost = 0.0;
        nextOffer = 0.0;
        if (ConfigValues.bidding_type == BidType.MENU) {
            Auctioneer.getInstance().getBidUI().getPage().set(0);
            Auctioneer.getInstance().getBidUI().nextPage();
        }
    }

    public static double increaseCostAndGet() {
        if (ConfigValues.exponential_increment_enabled) {
            FileConfiguration fileConfiguration = Auctioneer.getInstance().getConfig();
            for (String string : fileConfiguration.getConfigurationSection("exponential-increments").getKeys(false)) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!(previousCost > fileConfiguration.getDouble(stringBuilder.append("exponential-increments.").append(string).toString()))) continue;
                increment = (double)Integer.valueOf(string).intValue() / 100.0;
            }
        }
        if (previousCost == 0.0) {
            previousCost = baseCost;
            return previousCost;
        }
        return previousCost += baseCost * increment;
    }

    public static void makeOffer(double d) {
        String string = Utils.formatDouble(d);
        participants.forEach(player -> {
            player.sendMessage(Utils.colorize(ConfigValues.new_offer.replace("%coins%", string)));
            if (ConfigValues.new_auction_sound_enabled) {
                player.playSound(player.getLocation(), ConfigValues.new_offer_sound, 1.0f, 1.0f);
            }
        });
        offerMade = true;
    }

    public static void hideParticipants(Player player) {
        if (!ConfigValues.participants_invisible) {
            return;
        }
        participants.forEach(player2 -> {
            if (player2.equals(player)) {
                return;
            }
            player.hidePlayer((Plugin)Auctioneer.getInstance(), player2);
            player2.hidePlayer((Plugin)Auctioneer.getInstance(), player);
        });
    }

    public static void showParticipants(Player player) {
        if (!ConfigValues.participants_invisible) {
            return;
        }
        participants.forEach(player2 -> {
            if (player2.equals(player)) {
                return;
            }
            player.showPlayer((Plugin)Auctioneer.getInstance(), player2);
            player2.showPlayer((Plugin)Auctioneer.getInstance(), player);
        });
    }

    public ItemStack getTimerItem() {
        FileConfiguration fileConfiguration = this.auctioneer.getConfig();
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("bid-menu.timer.material")), timer.get());
        if (fileConfiguration.getBoolean("bid-menu.timer.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(fileConfiguration.getString("bid-menu.timer.name").replace("%end%", String.valueOf(timer.get()))));
        fileConfiguration.getStringList("bid-menu.timer.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string.replace("%end%", String.valueOf(timer.get())))));
        return itemBuilder.toItemStack();
    }

    static {
        active = false;
        auctionOpen = new AtomicBoolean(false);
        participants = new ArrayList<Player>();
        teleportCache = new HashMap();
        previousItems = new ArrayList<Integer>();
        auctions = new AtomicInteger(0);
        timer = new AtomicInteger();
        counter = new AtomicInteger();
        winners = new ArrayList<OfflinePlayer>();
        winnersItems = new ArrayList<Integer>();
        winnersCoins = new ArrayList<Double>();
    }
}

