/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.handlers;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.TimingData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TimeHandler {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private static BukkitTask timeRunnable = null;
    private static List<String> passedTimes = new ArrayList<String>();
    private static List<String> times = new ArrayList<String>();

    public void startRunnable() {
        final TimingData timingData = new TimingData();
        final FileConfiguration fileConfiguration = timingData.getData();
        times = ConfigValues.start_times;
        if (fileConfiguration.getStringList("passed") != null) {
            passedTimes = fileConfiguration.getStringList("passed");
        }
        timeRunnable = new BukkitRunnable(){
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

            public void run() {
                if (!fileConfiguration.getString("last-date").equals(TimeHandler.this.getCurrentDate())) {
                    passedTimes.clear();
                    fileConfiguration.set("last-date", (Object)TimeHandler.this.getCurrentDate());
                    fileConfiguration.set("passed", null);
                    new TimingData().save();
                }
                for (String string : times) {
                    if (passedTimes.contains(string)) continue;
                    try {
                        Date date;
                        Date date2 = this.dateFormat.parse(this.dateFormat.format(new Date()));
                        if (date2.compareTo(date = this.dateFormat.parse(string)) != 0 && date2.compareTo(date) != 1) continue;
                        new BukkitRunnable(){

                            public void run() {
                                if (ConfigValues.automatic_auctions_enabled) {
                                    AuctionData auctionData = new AuctionData();
                                    if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
                                        if (auctionData.getDisplayLocation() == null || auctionData.getPlayerTeleportLocation() == null || auctionData.getNPCSpawnLocation() == null || auctionData.getNPCTeleportLocation() == null) {
                                            return;
                                        }
                                        new AuctionHandler().start();
                                    } else {
                                        if (auctionData.getDisplayLocation() == null || auctionData.getPlayerTeleportLocation() == null) {
                                            return;
                                        }
                                        new AuctionHandler().start();
                                    }
                                }
                            }
                        }.runTask((Plugin)TimeHandler.this.auctioneer);
                        passedTimes.add(string);
                        fileConfiguration.set("passed", (Object)passedTimes);
                        timingData.save();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.auctioneer, 10L, 600L);
    }

    public String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/YY");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public String getTimeTillStart() {
        String string = null;
        try {
            string = this.getNextTime();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (string.equals("soon...")) {
            return "soon...";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date2 = simpleDateFormat.parse(string);
            date = simpleDateFormat.parse(simpleDateFormat.format(new Date()));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (date.after(date2)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            calendar.add(6, 1);
            date2.setTime(calendar.getTimeInMillis());
        }
        return Utils.formatTimeShort(TimeUnit.MILLISECONDS.toMillis(date2.getTime() - date.getTime()));
    }

    public String getNextTime() {
        String string = null;
        List<String> list = times;
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        Date date = simpleDateFormat.parse(simpleDateFormat.format(new Date()));
        for (String string2 : list) {
            if (passedTimes.contains(string2)) continue;
            Date date2 = simpleDateFormat.parse(string2);
            string = date.after(date2) ? "soon..." : string2;
            break;
        }
        if (string == null) {
            string = list.get(0);
        }
        return string;
    }
}

