/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.items;

import com.github.rossrao.auctioneer.auction.RewardData;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionItem {
    private RewardData rewardData = new RewardData();
    private FileConfiguration data = this.rewardData.getData();
    private ItemStack item;
    private double baseCost;
    private int id;
    private List<String> commands;
    private boolean giveItem;
    private String displayName;

    public AuctionItem(int n) {
        boolean bl = false;
        this.id = n;
        if (!this.data.isSet("auction-items." + n)) {
            ItemStack itemStack = new ItemBuilder(XMaterial.STONE_BUTTON).setName(Utils.colorize("&cNo Item Selected")).addLoreLine(Utils.colorize("&7Change this item by clicking one")).addLoreLine(Utils.colorize("&7of the items from your inventory.")).toItemStack();
            this.data.set("auction-items." + n + ".item-stack", (Object)itemStack);
            bl = true;
        }
        this.item = this.data.getItemStack("auction-items." + n + ".item-stack");
        if (!this.data.isSet("auction-items." + n + ".base-cost")) {
            this.data.set("auction-items." + n + ".base-cost", (Object)20000);
            bl = true;
        }
        this.baseCost = this.data.getDouble("auction-items." + n + ".base-cost");
        if (!this.data.isSet("auction-items." + n + ".commands")) {
            this.data.set("auction-items." + n + ".commands", new ArrayList());
            bl = true;
        }
        this.commands = this.data.getStringList("auction-items." + n + ".commands");
        if (!this.data.isSet("auction-items." + n + ".give-item")) {
            this.data.set("auction-items." + n + ".give-item", (Object)true);
            bl = true;
        }
        this.giveItem = this.data.getBoolean("auction-items." + n + ".give-item");
        if (!this.data.isSet("auction-items." + n + ".display-name")) {
            this.data.set("auction-items." + n + ".display-name", (Object)"");
            bl = true;
        }
        this.displayName = this.data.getString("auction-items." + n + ".display-name");
        if (bl) {
            this.rewardData.save();
        }
    }

    public int getID() {
        return this.id;
    }

    public ItemStack getItemStack(boolean bl) {
        if (bl) {
            ItemStack itemStack = this.item.clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(Utils.colorize(this.getDisplayName()));
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        return this.item;
    }

    public void setItemStack(ItemStack itemStack) {
        this.item = itemStack;
        this.data.set("auction-items." + this.id + ".item-stack", (Object)itemStack);
        this.rewardData.save();
    }

    public double getBaseCost() {
        return this.baseCost;
    }

    public void setBaseCost(double d) {
        this.baseCost = d;
        this.data.set("auction-items." + this.id + ".base-cost", (Object)d);
        this.rewardData.save();
    }

    public boolean isGiveItem() {
        return this.giveItem;
    }

    public void setGiveItem(boolean bl) {
        this.giveItem = bl;
        this.data.set("auction-items." + this.id + ".give-item", (Object)bl);
        this.rewardData.save();
    }

    public List<String> getCommands() {
        if (this.commands == null) {
            return new ArrayList<String>();
        }
        return this.commands;
    }

    public void setCommands(List<String> list) {
        this.commands = list.isEmpty() ? null : list;
        this.data.set("auction-items." + this.id + ".commands", this.commands);
        this.rewardData.save();
    }

    public String getDisplayName() {
        if (this.hasDisplayName()) {
            return this.displayName;
        }
        if (this.item.hasItemMeta() && this.item.getItemMeta().hasDisplayName()) {
            return this.item.getItemMeta().getDisplayName();
        }
        return this.item.getType().name();
    }

    public boolean hasDisplayName() {
        return this.displayName != null && !this.displayName.equalsIgnoreCase("");
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.data.set("auction-items." + this.id + ".display-name", (Object)Utils.colorize(string));
        this.rewardData.save();
    }

    public void deleteDisplayName() {
        this.displayName = "";
        this.data.set("auction-items." + this.id + ".display-name", (Object)"");
    }

    public void delete() {
        this.data.set("auction-items." + this.id, null);
        this.rewardData.save();
    }

    public void add() {
        this.data.set("auction-items." + this.id + ".item-stack", (Object)this.item);
        this.data.set("auction-items." + this.id + ".base-cost", (Object)this.baseCost);
        this.data.set("auction-items." + this.id + ".commands", this.commands);
        this.data.set("auction-items" + this.id + "give-item", (Object)this.giveItem);
        this.data.set("auction-items." + this.id + "display-name", (Object)this.displayName);
        this.rewardData.save();
    }
}

