/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.listeners;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.auction.menus.DisplayItemUI;
import com.github.rossrao.auctioneer.data.ConfigValues;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;

public class ArmorStandListener
implements Listener {
    private Auctioneer auctioneer;

    public ArmorStandListener(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (!playerInteractAtEntityEvent.getRightClicked().getUniqueId().equals(new AuctionData().getDisplayID())) {
            return;
        }
        playerInteractAtEntityEvent.setCancelled(true);
        Player player = playerInteractAtEntityEvent.getPlayer();
        switch (ConfigValues.bidding_type) {
            case CHAT: {
                if (!ConfigValues.display_menu_enabled) {
                    return;
                }
                if (AuctionHandler.auctionOpen.get() && AuctionHandler.isParticipant(player)) {
                    player.openInventory(new DisplayItemUI(this.auctioneer).open(player));
                }
            }
            case MENU: {
                if (!AuctionHandler.menuAvailable || !AuctionHandler.isParticipant(player) || !AuctionHandler.offerMade) break;
                player.openInventory(this.auctioneer.getBidUI().getInventory());
            }
        }
    }
}

