/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.listeners;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.auction.menus.ItemEditorUI;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.enums.BidType;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XSound;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class AsyncChatListener
implements Listener {
    private Auctioneer auctioneer;
    public static boolean bidPlaced = false;
    public static HashMap<UUID, String> editorUsers = new HashMap();

    public AsyncChatListener(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onAsyncPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        String string = asyncPlayerChatEvent.getMessage();
        if (editorUsers.containsKey(player.getUniqueId())) {
            String string2 = editorUsers.get(player.getUniqueId());
            if (string2.equalsIgnoreCase("command")) {
                asyncPlayerChatEvent.setCancelled(true);
                AuctionItem auctionItem = ItemEditorUI.auctionItem;
                List<String> list = auctionItem.getCommands();
                list.add(Utils.stripColors(string));
                auctionItem.setCommands(list);
                player.playSound(player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Auctioneer.getInstance(), () -> player.openInventory(new ItemEditorUI(this.auctioneer).open(player, auctionItem)), 1L);
                editorUsers.remove(player.getUniqueId());
            } else if (string2.equalsIgnoreCase("base-cost")) {
                if (Utils.isDouble(Utils.stripColors(string))) {
                    asyncPlayerChatEvent.setCancelled(true);
                    AuctionItem auctionItem = ItemEditorUI.auctionItem;
                    Double d = Double.valueOf(Utils.stripColors(string));
                    auctionItem.setBaseCost(d);
                    player.playSound(player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Auctioneer.getInstance(), () -> player.openInventory(new ItemEditorUI(this.auctioneer).open(player, auctionItem)), 1L);
                    editorUsers.remove(player.getUniqueId());
                } else {
                    asyncPlayerChatEvent.setCancelled(true);
                    player.sendMessage(Utils.colorize("&cThat is not a valid amount, please try again..."));
                    player.playSound(player.getLocation(), XSound.ENTITY_VILLAGER_NO.parseSound(), 1.0f, 1.0f);
                }
            } else if (string2.equalsIgnoreCase("display-name")) {
                asyncPlayerChatEvent.setCancelled(true);
                AuctionItem auctionItem = ItemEditorUI.auctionItem;
                auctionItem.setDisplayName(Utils.colorize(string));
                player.playSound(player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Auctioneer.getInstance(), () -> player.openInventory(new ItemEditorUI(this.auctioneer).open(player, auctionItem)), 1L);
                editorUsers.remove(player.getUniqueId());
            }
            return;
        }
        if (ConfigValues.bidding_type != BidType.CHAT) {
            return;
        }
        for (String string3 : ConfigValues.bidding_words) {
            if (!Utils.stripColors(string).equalsIgnoreCase(string3)) continue;
            if (!AuctionHandler.isParticipant(player)) {
                return;
            }
            if (!AuctionHandler.auctionOpen.get()) {
                return;
            }
            if (!AuctionHandler.offerMade) {
                asyncPlayerChatEvent.setCancelled(true);
                player.sendMessage(Utils.colorize(ConfigValues.no_offers));
                return;
            }
            if (AuctionHandler.timer.get() < 1) {
                asyncPlayerChatEvent.setCancelled(true);
                player.sendMessage(Utils.colorize(ConfigValues.no_time_left));
                return;
            }
            double d = AuctionHandler.currentCost;
            AsyncChatListener asyncChatListener = this;
            if (asyncChatListener.auctioneer.getEconomy().getBalance((OfflinePlayer)player) < d) {
                asyncPlayerChatEvent.setCancelled(true);
                player.sendMessage(Utils.colorize(ConfigValues.not_enough_money));
                if (ConfigValues.not_enough_money_sound_enabled) {
                    player.playSound(player.getLocation(), ConfigValues.not_enough_money_sound, 1.0f, 1.0f);
                }
                return;
            }
            if (ConfigValues.outbidding_self_enabled && AuctionHandler.lastBidder == player.getUniqueId()) {
                asyncPlayerChatEvent.setCancelled(true);
                player.sendMessage(Utils.colorize(ConfigValues.outbidding_self));
            }
            if (bidPlaced) {
                asyncPlayerChatEvent.setCancelled(true);
                player.sendMessage(Utils.colorize(ConfigValues.someone_already_bid));
                return;
            }
            asyncPlayerChatEvent.setCancelled(true);
            AuctionHandler.placeBid(player);
            bidPlaced = true;
            return;
        }
    }
}

