/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class DisplayItemUI
implements Listener {
    private Auctioneer auctioneer;
    private Inventory inv;
    private Player player;

    public DisplayItemUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    public Inventory open(Player player) {
        Inventory inventory;
        this.inv = inventory = Bukkit.createInventory(null, (int)(9 * ConfigValues.display_menu_rows), (String)Utils.colorize(ConfigValues.display_menu_title));
        this.player = player;
        ConfigValues.display_menu_background_slots.forEach(n -> this.inv.setItem(n.intValue(), ConfigValues.display_menu_background));
        this.inv.setItem(ConfigValues.display_menu_display_item_slot, AuctionHandler.currentItem.getItemStack(true));
        this.inv.setItem(ConfigValues.display_menu_close_slot, ConfigValues.display_menu_close);
        inventory.setContents(this.inv.getContents());
        return this.inv;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getSlot() == ConfigValues.display_menu_close_slot) {
            inventoryClickEvent.getWhoClicked().closeInventory();
            return;
        }
    }
}

