/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.RewardData;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.auction.menus.ItemEditorUI;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import com.github.rossrao.auctioneer.utils.xseries.XSound;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemsUI
implements Listener {
    private Auctioneer auctioneer;
    private AuctionData auctionData;
    private RewardData rewardData;
    private Inventory inv;
    private Player player;
    private int page;
    private int[] backgroundSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 51, 52, 53};
    private HashMap<Integer, AuctionItem> items = new HashMap();

    public ItemsUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.auctionData = new AuctionData();
        this.rewardData = new RewardData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    public Inventory open(Player player, int n) {
        Inventory inventory;
        this.inv = inventory = Bukkit.createInventory(null, (int)54, (String)"Auction Items");
        this.player = player;
        this.page = n;
        ItemStack itemStack = new ItemBuilder(XMaterial.BLACK_STAINED_GLASS_PANE).setName(Utils.colorize("&7")).toItemStack();
        for (int n2 : this.backgroundSlots) {
            this.inv.setItem(n2, itemStack);
        }
        ItemStack itemStack2 = new ItemBuilder(XMaterial.BARRIER).setName(Utils.colorize("&cClose Menu")).toItemStack();
        this.inv.setItem(49, itemStack2);
        ItemStack itemStack3 = new ItemBuilder(XMaterial.EMERALD).setName(Utils.colorize("&aAdd Item")).toItemStack();
        this.inv.setItem(50, itemStack3);
        this.loadItems();
        inventory.setContents(this.inv.getContents());
        return this.inv;
    }

    private void loadItems() {
        ItemStack itemStack;
        this.items.clear();
        List<AuctionItem> list = this.rewardData.getAuctionItems();
        int n = list.size();
        if (n > 28 * this.page) {
            itemStack = new ItemBuilder(XMaterial.ARROW).setName("&aNext Page").toItemStack();
            this.inv.setItem(53, itemStack);
        }
        if (this.page > 1) {
            itemStack = new ItemBuilder(XMaterial.ARROW).setName("&aPrevious Page").toItemStack();
            this.inv.setItem(45, itemStack);
        }
        for (int i = this.page * 28 - 28; i < this.page * 28 && i < n; ++i) {
            AuctionItem auctionItem = list.get(i);
            ItemStack itemStack2 = new ItemBuilder(auctionItem.getItemStack(true).clone()).addLoreLine(Utils.colorize("&8-------------------")).addLoreLine(Utils.colorize("&bClick to edit!")).addLoreLine(Utils.colorize("&3Shift-Click to delete!")).toItemStack();
            this.items.put(this.inv.firstEmpty(), auctionItem);
            this.inv.setItem(this.inv.firstEmpty(), itemStack2);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        int n = inventoryClickEvent.getSlot();
        ClickType clickType = inventoryClickEvent.getClick();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (n == 49) {
            this.player.closeInventory();
            return;
        }
        if (n == 50 && itemStack.getType() == XMaterial.EMERALD.parseMaterial()) {
            AuctionItem auctionItem;
            List<AuctionItem> list = this.rewardData.getAuctionItems();
            if (list.isEmpty()) {
                auctionItem = new AuctionItem(1);
            } else {
                int n2 = list.get(list.size() - 1).getID() + 1;
                auctionItem = new AuctionItem(n2);
            }
            this.player.openInventory(new ItemEditorUI(this.auctioneer).open(this.player, auctionItem));
            this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
            return;
        }
        if (n == 53 && itemStack.getType() == XMaterial.ARROW.parseMaterial()) {
            this.player.openInventory(this.open(this.player, this.page + 1));
            return;
        }
        if (n == 45 && itemStack.getType() == XMaterial.ARROW.parseMaterial()) {
            this.player.openInventory(this.open(this.player, this.page - 1));
            return;
        }
        if (this.items.containsKey(n)) {
            AuctionItem auctionItem = this.items.get(n);
            if (clickType == ClickType.SHIFT_LEFT || clickType == ClickType.SHIFT_RIGHT) {
                this.player.closeInventory();
                this.player.sendMessage(Utils.colorize("&bYou deleted item #" + auctionItem.getID() + " from the auctions."));
                auctionItem.delete();
            } else {
                this.player.openInventory(new ItemEditorUI(this.auctioneer).open(this.player, auctionItem));
            }
            this.player.playSound(this.player.getLocation(), XSound.UI_BUTTON_CLICK.parseSound(), 1.0f, 1.0f);
            return;
        }
    }
}

