/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.auction.handlers.TimeHandler;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class JoinUI
implements Listener {
    private Auctioneer auctioneer;
    private AuctionData auctionData;
    private FileConfiguration config;
    private Inventory inv;
    private Player player;

    public JoinUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.auctionData = new AuctionData();
        this.config = auctioneer.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    public Inventory open(Player player) {
        Inventory inventory;
        this.inv = inventory = Bukkit.createInventory(null, (int)(9 * ConfigValues.joining_menu_rows), (String)Utils.colorize(ConfigValues.joining_menu_title));
        this.player = player;
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.background.material")));
        if (this.config.getBoolean("joining-menu.background.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.background.name")));
        this.config.getStringList("joining-menu.background.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        ConfigValues.joining_menu_background_slots.forEach(n -> this.inv.setItem(n.intValue(), itemBuilder.toItemStack()));
        ItemBuilder itemBuilder2 = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.information.material")));
        if (this.config.getBoolean("joining-menu.information.glowing")) {
            itemBuilder2.setGlowing();
        }
        itemBuilder2.setName(Utils.colorize(this.config.getString("joining-menu.information.name")));
        this.config.getStringList("joining-menu.information.lore").forEach(string -> itemBuilder2.addLoreLine(Utils.colorize(string.replace("%timer%", new TimeHandler().getTimeTillStart()).replace("%entry_cost%", Utils.formatDouble(ConfigValues.join_money_requirement)))));
        this.inv.setItem(ConfigValues.joining_menu_information_slot, itemBuilder2.toItemStack());
        ItemBuilder itemBuilder3 = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.close.material")));
        if (this.config.getBoolean("joining-menu.close.glowing")) {
            itemBuilder3.setGlowing();
        }
        itemBuilder3.setName(Utils.colorize(this.config.getString("joining-menu.close.name")));
        this.config.getStringList("joining-menu.close.lore").forEach(string -> itemBuilder3.addLoreLine(Utils.colorize(string)));
        this.inv.setItem(ConfigValues.joining_menu_close_slot, itemBuilder3.toItemStack());
        this.inv.setItem(ConfigValues.joining_menu_join_item_slot, this.getFinalJoinItem());
        inventory.setContents(this.inv.getContents());
        return this.inv;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        int n = inventoryClickEvent.getSlot();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (n == ConfigValues.joining_menu_close_slot) {
            this.player.closeInventory();
            return;
        }
        if (n == ConfigValues.joining_menu_join_item_slot && itemStack.equals((Object)this.getJoinItem().toItemStack())) {
            AuctionHandler.addParticipant(this.player);
            return;
        }
    }

    private ItemStack getFinalJoinItem() {
        if (!AuctionHandler.active) {
            return this.getNoAuctionActiveItem().toItemStack();
        }
        if (ConfigValues.join_permission_enabled && !this.player.hasPermission(ConfigValues.join_permission)) {
            return this.getNoPermissionItem().toItemStack();
        }
        if (AuctionHandler.isParticipant(this.player)) {
            return this.getAlreadyParticipantItem().toItemStack();
        }
        if (Auctioneer.getEconomy().getBalance((OfflinePlayer)this.player) < ConfigValues.join_money_requirement) {
            return this.getNotEnoughMoneyItem().toItemStack();
        }
        return this.getJoinItem().toItemStack();
    }

    private ItemBuilder getNoAuctionActiveItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.no-active-auction.material")));
        if (this.config.getBoolean("joining-menu.no-active-auction.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.no-active-auction.name")));
        this.config.getStringList("joining-menu.no-active-auction.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string.replace("%timer%", new TimeHandler().getTimeTillStart()))));
        return itemBuilder;
    }

    private ItemBuilder getNoPermissionItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.no-join-permission.material")));
        if (this.config.getBoolean("joining-menu.no-join-permission.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.no-join-permission.name")));
        this.config.getStringList("joining-menu.no-join-permission.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        return itemBuilder;
    }

    private ItemBuilder getAlreadyParticipantItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.already-at-auction.material")));
        if (this.config.getBoolean("joining-menu.already-at-auction.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.already-at-auction.name")));
        this.config.getStringList("joining-menu.already-at-auction.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        return itemBuilder;
    }

    private ItemBuilder getNotEnoughMoneyItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.not-enough-money.material")));
        if (this.config.getBoolean("joining-menu.not-enough-money.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.not-enough-money.name")));
        this.config.getStringList("joining-menu.not-enough-money.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string.replace("%entry_cost%", Utils.formatDouble(ConfigValues.join_money_requirement)))));
        return itemBuilder;
    }

    private ItemBuilder getJoinItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("joining-menu.join-auction.material")));
        if (this.config.getBoolean("joining-menu.join-auction.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("joining-menu.join-auction.name")));
        this.config.getStringList("joining-menu.join-auction.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        return itemBuilder;
    }
}

