/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RewardCollectorUI
implements Listener {
    private Auctioneer auctioneer;
    private AuctionData auctionData;
    private Inventory inv;
    private Player player;
    private HashMap<Integer, AuctionItem> items = new HashMap();

    public RewardCollectorUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.auctionData = new AuctionData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
    }

    public Inventory open(Player player) {
        Inventory inventory;
        this.inv = inventory = Bukkit.createInventory(null, (int)(9 * ConfigValues.reward_menu_rows), (String)Utils.colorize(ConfigValues.reward_menu_title));
        this.player = player;
        ConfigValues.reward_menu_background_slots.forEach(n -> this.inv.setItem(n.intValue(), ConfigValues.reward_menu_background));
        this.inv.setItem(ConfigValues.reward_menu_close_slot, ConfigValues.reward_menu_close);
        this.inv.setItem(ConfigValues.reward_menu_claim_all_slot, ConfigValues.reward_menu_claim_all);
        this.auctionData.getRewardFromCache(player.getUniqueId()).forEach(n -> {
            AuctionItem auctionItem = new AuctionItem((int)n);
            ItemStack itemStack = auctionItem.getItemStack(true).clone();
            ItemBuilder itemBuilder = new ItemBuilder(itemStack);
            itemBuilder.setName(auctionItem.getDisplayName());
            ConfigValues.reward_menu_collect_item_lore_addon.forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
            this.items.put(this.inv.firstEmpty(), auctionItem);
            this.inv.setItem(this.inv.firstEmpty(), itemBuilder.toItemStack());
        });
        inventory.setContents(this.inv.getContents());
        return this.inv;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        int n = inventoryClickEvent.getSlot();
        if (n == ConfigValues.reward_menu_close_slot) {
            this.player.closeInventory();
            return;
        }
        if (n == ConfigValues.reward_menu_claim_all_slot) {
            for (int n2 : this.items.keySet()) {
                AuctionItem auctionItem = this.items.get(n2);
                if (auctionItem.isGiveItem()) {
                    if (this.player.getInventory().firstEmpty() != -1) {
                        this.player.getInventory().addItem(new ItemStack[]{auctionItem.getItemStack(false)});
                    } else {
                        this.player.sendMessage(Utils.colorize(ConfigValues.not_enough_inventory_space));
                        this.player.closeInventory();
                        break;
                    }
                }
                if (!auctionItem.getCommands().isEmpty()) {
                    auctionItem.getCommands().forEach(string -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", this.player.getName())));
                }
                this.auctionData.removeRewardFromCache(this.player.getUniqueId(), auctionItem);
                this.sendClaimedMessage(this.player, auctionItem);
            }
            this.player.closeInventory();
            return;
        }
        if (this.items.containsKey(n)) {
            AuctionItem auctionItem = this.items.get(n);
            if (auctionItem.isGiveItem()) {
                if (this.player.getInventory().firstEmpty() != -1) {
                    this.player.getInventory().addItem(new ItemStack[]{auctionItem.getItemStack(false)});
                } else {
                    this.player.sendMessage(Utils.colorize(ConfigValues.not_enough_inventory_space));
                    return;
                }
            }
            if (!auctionItem.getCommands().isEmpty()) {
                auctionItem.getCommands().forEach(string -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%player%", this.player.getName())));
            }
            this.auctionData.removeRewardFromCache(this.player.getUniqueId(), auctionItem);
            this.player.closeInventory();
            this.sendClaimedMessage(this.player, auctionItem);
            return;
        }
    }

    private void sendClaimedMessage(Player player, AuctionItem auctionItem) {
        player.sendMessage(Utils.colorize(ConfigValues.reward_claimed.replace("%item%", auctionItem.getDisplayName())));
    }
}

