/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.utils;

import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack item;

    public ItemBuilder(XMaterial xMaterial) {
        this(xMaterial, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.item = itemStack;
    }

    public ItemBuilder(XMaterial xMaterial, int n) {
        this.item = new ItemStack(xMaterial.parseMaterial(), n, (short)xMaterial.getData());
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.item);
    }

    public ItemBuilder setDurability(short s) {
        this.item.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setDisplayName(Utils.colorize(string));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.item.addUnsafeEnchantment(enchantment, n);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.item.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.item.getItemMeta();
            skullMeta.setOwner(string);
            this.item.setItemMeta((ItemMeta)skullMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.addEnchant(enchantment, n, true);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.item.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.item.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setLore(Utils.colorize(Arrays.asList(stringArray)));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setLore(Utils.colorize(list));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList arrayList = new ArrayList(itemMeta.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        itemMeta.setLore(arrayList);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList arrayList = new ArrayList(itemMeta.getLore());
        if (n < 0 || n > arrayList.size()) {
            return this;
        }
        arrayList.remove(n);
        itemMeta.setLore(arrayList);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (itemMeta.hasLore()) {
            arrayList = new ArrayList(itemMeta.getLore());
        }
        arrayList.add(string);
        itemMeta.setLore(arrayList);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        arrayList.set(n, string);
        itemMeta.setLore(arrayList);
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.item.getItemMeta();
            leatherArmorMeta.setColor(color);
            this.item.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder setGlowing() {
        if (this.item.getEnchantments().isEmpty()) {
            this.addEnchant(Enchantment.LUCK, 1);
            this.hideAttributes();
        }
        return this;
    }

    public ItemBuilder hideAttributes() {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemStack toItemStack() {
        return this.item;
    }
}

