/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.api;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.black_ixx.bossshop.api.BSAddonStorage;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BSAddonConfig
implements BSAddonStorage {
    boolean isSaving = false;
    private Plugin plugin;
    private File file;
    private YamlConfiguration config;

    public BSAddonConfig(Plugin plugin, String file_name) {
        this.plugin = plugin;
        this.file = new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/addons/" + plugin.getName() + "/" + file_name + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public BSAddonConfig(Plugin plugin, File file) {
        this.plugin = plugin;
        this.file = file;
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    @Override
    public boolean save() {
        if (this.isSaving) {
            return false;
        }
        this.isSaving = true;
        try {
            this.config.save(this.file);
        }
        catch (IOException e1) {
            this.plugin.getLogger().warning("File I/O Exception on saving " + this.file.getName());
            e1.printStackTrace();
            return false;
        }
        this.isSaving = false;
        return true;
    }

    @Override
    public void saveAsync() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, new Runnable(){

            @Override
            public void run() {
                BSAddonConfig.this.save();
            }
        });
    }

    public boolean reload() {
        try {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    @Override
    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    @Override
    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    @Override
    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public void addDefault(String path, Object value) {
        if (!this.config.contains(path)) {
            this.config.set(path, value);
        }
    }

    @Override
    public boolean containsPath(String key) {
        return this.config.contains(key);
    }

    @Override
    public Set<String> listKeys(String section, boolean deep) {
        YamlConfiguration s = this.config;
        if (section != null) {
            s = s.getConfigurationSection(section);
        }
        if (s != null) {
            return s.getKeys(deep);
        }
        return null;
    }

    @Override
    public void deleteAll(String section) {
        YamlConfiguration s = this.config;
        if (section != null) {
            s = s.getConfigurationSection(section);
        }
        if (s != null) {
            for (String key : s.getKeys(true)) {
                s.set(key, null);
            }
            this.config.set(s.getCurrentPath(), null);
        }
    }

    @Override
    public boolean pasteContentFrom(BSAddonStorage source) {
        if (source instanceof BSAddonConfig) {
            BSAddonConfig c = (BSAddonConfig)source;
            try {
                source.save();
                Files.copy((File)c.getFile(), (File)this.file);
                this.reload();
            }
            catch (IOException e) {
                ClassManager.manager.getBugFinder().warn("Unable to copy storage file from '" + c.getFile().getPath() + "' to '" + this.file.getPath() + "'.");
                return false;
            }
            return true;
        }
        return false;
    }
}

