/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core;

import java.io.File;
import java.util.HashMap;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.managers.config.FileHandler;
import org.black_ixx.bossshop.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class BSShops {
    private HashMap<Integer, BSShop> shops = new HashMap();
    private HashMap<String, Integer> shopsIds = new HashMap();
    private int id = 0;

    public BSShops(BossShop plugin, Settings settings) {
        File folder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "shops" + File.separator);
        new FileHandler().exportShops(plugin);
        boolean enableShopCommands = this.loadShops(folder, settings, "");
        ClassManager.manager.getSettings().setShopCommandsEnabled(enableShopCommands);
        BossShop.log("Loaded " + this.shops.size() + " Shops!");
    }

    private boolean loadShops(File folder, Settings settings, String parentPath) {
        boolean enableShopCommands = false;
        for (File f : folder.listFiles()) {
            BSShop shop;
            if (f == null) continue;
            if (f.isDirectory()) {
                if (!settings.getLoadSubfoldersEnabled() || !this.loadShops(f, settings, f.getName() + File.separator)) continue;
                enableShopCommands = true;
                continue;
            }
            if (!f.isFile() || !f.getName().contains(".yml") || (shop = this.loadShop(f, parentPath)).getCommands() == null) continue;
            enableShopCommands = true;
        }
        return enableShopCommands;
    }

    public void addShop(BSShop shop) {
        this.shops.put(shop.getShopId(), shop);
        if (this.shopsIds.containsKey(shop.getShopName().toLowerCase())) {
            ClassManager.manager.getBugFinder().warn("Two Shops with the same Name (" + shop.getShopName().toLowerCase() + ") are loaded. When opening a Shop via Name, only one of this Shops will be opened!");
        }
        this.shopsIds.put(shop.getShopName().toLowerCase(), shop.getShopId());
    }

    public BSShop loadShop(File f, String parentPath) {
        String name = parentPath + f.getName();
        BSConfigShop shop = new BSConfigShop(this.createId(), name, this);
        this.addShop(shop);
        return shop;
    }

    public void unloadShop(BSShop shop) {
        int id = this.getShopId(shop.getShopName());
        this.shopsIds.remove(shop.getShopName());
        this.shops.remove(id);
        shop.close();
    }

    public void openShop(Player p, String name) {
        if (!this.isShop(name)) {
            ClassManager.manager.getMessageHandler().sendMessage("Main.ShopNotExisting", (CommandSender)p);
            return;
        }
        this.openShop(p, this.getShopFast(name));
    }

    public void openShop(Player p, BSShop shop) {
        BSShopHolder holder;
        BSShopHolder oldShopHolder;
        int page = 0;
        boolean rememberCurrentShop = true;
        InventoryView view = p.getOpenInventory();
        if (view != null && view.getTopInventory() != null && view.getTopInventory().getHolder() instanceof BSShopHolder && (oldShopHolder = (holder = (BSShopHolder)view.getTopInventory().getHolder()).getPreviousShopHolder()) != null && oldShopHolder.getShop() == shop) {
            page = oldShopHolder.getPage();
            rememberCurrentShop = false;
        }
        shop.openInventory(p, page, rememberCurrentShop);
    }

    public BSShop getShop(String name) {
        return this.getShop(this.getShopId(name));
    }

    public BSShop getShopFast(String name) {
        return this.getShopFast(this.getShopId(name));
    }

    public BSShop getShopByCommand(String playerCommand) {
        if (playerCommand != null && playerCommand.length() > 0) {
            for (BSShop shop : this.shops.values()) {
                String[] commands = shop.getCommands();
                if (commands == null) continue;
                for (String command : commands) {
                    if (!command.equalsIgnoreCase(playerCommand)) continue;
                    return shop;
                }
            }
        }
        return null;
    }

    public BSShop getShop(int id) {
        return this.shops.getOrDefault(id, null);
    }

    public BSShop getShopFast(int id) {
        return this.shops.get(id);
    }

    public int getShopId(String name) {
        if (!this.shopsIds.containsKey(name = name.toLowerCase())) {
            return -1;
        }
        return this.shopsIds.get(name);
    }

    public boolean isShop(String name) {
        return this.shopsIds.containsKey(name);
    }

    public boolean isShop(int id) {
        return this.shops.containsKey(id);
    }

    public HashMap<Integer, BSShop> getShops() {
        return this.shops;
    }

    public HashMap<String, Integer> getShopIds() {
        return this.shopsIds;
    }

    public int createId() {
        ++this.id;
        return this.id;
    }

    public void refreshShops(boolean serverPinging) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            Inventory openInventory;
            BSShopHolder h;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || !(h = (BSShopHolder)(openInventory = p.getOpenInventory().getTopInventory()).getHolder()).getShop().isCustomizable() || serverPinging || ClassManager.manager.getSettings().getServerPingingEnabled(true) && ClassManager.manager.getServerPingingManager().containsServerpinging(h.getShop())) continue;
            h.getShop().updateInventory(openInventory, h, p, ClassManager.manager, h.getPage(), h.getHighestPage(), true);
        }
    }
}

