/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core.rewards;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeBungeeCordCommand;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeBungeeCordServer;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeClose;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeCommand;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeCustom;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeEnchantment;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeExp;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeItem;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeItemAll;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeMoney;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeNothing;
import org.black_ixx.bossshop.core.rewards.BSRewardTypePermission;
import org.black_ixx.bossshop.core.rewards.BSRewardTypePlayerCommand;
import org.black_ixx.bossshop.core.rewards.BSRewardTypePlayerCommandOp;
import org.black_ixx.bossshop.core.rewards.BSRewardTypePoints;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeShop;
import org.black_ixx.bossshop.core.rewards.BSRewardTypeShopPage;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public abstract class BSRewardType {
    public static BSRewardType BungeeCordCommand;
    public static BSRewardType BungeeCordServer;
    public static BSRewardType Close;
    public static BSRewardType Command;
    public static BSRewardType Custom;
    public static BSRewardType Enchantment;
    public static BSRewardType Exp;
    public static BSRewardType Item;
    public static BSRewardType ItemAll;
    public static BSRewardType Money;
    public static BSRewardType Nothing;
    public static BSRewardType Permission;
    public static BSRewardType PlayerCommand;
    public static BSRewardType PlayerCommandOp;
    public static BSRewardType Points;
    public static BSRewardType Shop;
    public static BSRewardType ShopBack;
    public static BSRewardType ShopPage;
    private static List<BSRewardType> types;
    private String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<BSRewardType>();
        BungeeCordCommand = BSRewardType.registerType(new BSRewardTypeBungeeCordCommand());
        BungeeCordServer = BSRewardType.registerType(new BSRewardTypeBungeeCordServer());
        Close = BSRewardType.registerType(new BSRewardTypeClose());
        Custom = BSRewardType.registerType(new BSRewardTypeCustom());
        Command = BSRewardType.registerType(new BSRewardTypeCommand());
        Enchantment = BSRewardType.registerType(new BSRewardTypeEnchantment());
        Exp = BSRewardType.registerType(new BSRewardTypeExp());
        Item = BSRewardType.registerType(new BSRewardTypeItem());
        ItemAll = BSRewardType.registerType(new BSRewardTypeItemAll());
        Money = BSRewardType.registerType(new BSRewardTypeMoney());
        Nothing = BSRewardType.registerType(new BSRewardTypeNothing());
        Permission = BSRewardType.registerType(new BSRewardTypePermission());
        PlayerCommand = BSRewardType.registerType(new BSRewardTypePlayerCommand());
        PlayerCommandOp = BSRewardType.registerType(new BSRewardTypePlayerCommandOp());
        Points = BSRewardType.registerType(new BSRewardTypePoints());
        Shop = BSRewardType.registerType(new BSRewardTypeShop());
        ShopPage = BSRewardType.registerType(new BSRewardTypeShopPage());
    }

    public static BSRewardType registerType(BSRewardType type) {
        types.add(type);
        return type;
    }

    public static BSRewardType detectType(String s) {
        if (s != null) {
            for (BSRewardType type : types) {
                if (!type.isType(s)) continue;
                return type;
            }
        }
        return Nothing;
    }

    public static List<BSRewardType> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        BSRewardType.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public void updateNames() {
        this.names = this.createNames();
    }

    public abstract Object createObject(Object var1, boolean var2);

    public abstract boolean validityCheck(String var1, Object var2);

    public abstract void enableType();

    public abstract boolean canBuy(Player var1, BSBuy var2, boolean var3, Object var4, ClickType var5);

    public abstract void giveReward(Player var1, BSBuy var2, Object var3, ClickType var4);

    public abstract String getDisplayReward(Player var1, BSBuy var2, Object var3, ClickType var4);

    public abstract String[] createNames();

    public boolean logTransaction() {
        return true;
    }

    public boolean isPlayerDependend(BSBuy buy, ClickType clicktype) {
        return this.supportsMultipliers() && ClassManager.manager.getMultiplierHandler().hasMultipliers() || buy.getRewardType(clicktype) == ItemAll && ClassManager.manager.getSettings().getItemAllShowFinalReward();
    }

    public boolean supportsMultipliers() {
        return false;
    }

    public boolean isActualReward() {
        return true;
    }

    public boolean allowAsync() {
        return false;
    }

    public boolean overridesPrice() {
        return false;
    }

    public String getPriceReturnMessage(Player p, BSBuy buy, Object price, ClickType clickType) {
        return null;
    }

    public abstract boolean mightNeedShopUpdate();
}

