/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.inbuiltaddons.advancedshops;

import java.util.HashMap;
import org.black_ixx.bossshop.core.BSInputType;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.events.BSCheckStringForFeaturesEvent;
import org.black_ixx.bossshop.events.BSCreateShopItemEvent;
import org.black_ixx.bossshop.inbuiltaddons.advancedshops.ActionSet;
import org.black_ixx.bossshop.inbuiltaddons.advancedshops.BSBuyAdvanced;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;

public class ShopItemCreationListener
implements Listener {
    @EventHandler
    public void onCreate(BSCreateShopItemEvent event) {
        ConfigurationSection c = event.getConfigurationSection();
        HashMap<ClickType, ActionSet> map = null;
        for (ClickType clicktype : ClickType.values()) {
            String s = clicktype.name().toLowerCase();
            if (!c.contains("RewardType_" + s)) continue;
            if (map == null) {
                map = new HashMap<ClickType, ActionSet>();
            }
            String priceType = c.getString("PriceType_" + s);
            String rewardType = c.getString("RewardType_" + s);
            String message = c.getString("Message_" + s);
            String permission = c.getString("ExtraPermission_" + s);
            if (permission == null || permission == "") {
                permission = null;
            }
            BSRewardType rewardT = BSRewardType.detectType(rewardType);
            BSPriceType priceT = BSPriceType.detectType(priceType);
            if (rewardT == null) {
                ClassManager.manager.getBugFinder().severe("Was not able to create advanced BuyItem '" + event.getShopItemName() + "'! '" + rewardType + "' is not a valid RewardType! Switching back to simple kind of BuyItem.");
                ClassManager.manager.getBugFinder().severe("Valid RewardTypes:");
                for (BSRewardType bSRewardType : BSRewardType.values()) {
                    ClassManager.manager.getBugFinder().severe("-" + bSRewardType.name());
                }
                return;
            }
            if (priceT == null) {
                ClassManager.manager.getBugFinder().severe("Was not able to create advanced BuyItem '" + event.getShopItemName() + "!' '" + priceType + "' is not a valid PriceType! Switching back to simple kind of BuyItem.");
                ClassManager.manager.getBugFinder().severe("Valid PriceTypes:");
                for (BSPriceType bSPriceType : BSPriceType.values()) {
                    ClassManager.manager.getBugFinder().severe("-" + bSPriceType.name());
                }
                return;
            }
            rewardT.enableType();
            priceT.enableType();
            Object price = c.get("Price_" + s);
            Object object = c.get("Reward_" + s);
            price = priceT.createObject(price, true);
            Object object2 = rewardT.createObject(object, true);
            if (!priceT.validityCheck(event.getShopItemName(), price)) {
                return;
            }
            if (!rewardT.validityCheck(event.getShopItemName(), object2)) {
                return;
            }
            String inputtypename = c.getString("ForceInput_" + s);
            String inputtext = c.getString("ForceInputMessage_" + s);
            BSInputType inputtype = null;
            if (inputtypename != null) {
                for (BSInputType it : BSInputType.values()) {
                    if (!it.name().equalsIgnoreCase(inputtypename)) continue;
                    inputtype = it;
                    break;
                }
                if (inputtype == null) {
                    ClassManager.manager.getBugFinder().warn("Invalid advanced ForceInput type: '" + inputtypename + "' of shopitem '" + event.getShopItemName());
                }
            }
            map.put(clicktype, new ActionSet(rewardT, priceT, object2, price, message, permission, inputtype, inputtext));
        }
        BSBuyAdvanced buy = new BSBuyAdvanced(event.getRewardType(), event.getPriceType(), event.getReward(), event.getPrice(), event.getMessage(), event.getInventoryLocation(), event.getExtraPermission(), event.getShopItemName(), event.getCondition(), event.getInputType(), event.getInputText(), map);
        event.useCustomShopItem(buy);
    }

    @EventHandler
    public void onCheckStringForFeatures(BSCheckStringForFeaturesEvent event) {
        if (event.getShopItem() instanceof BSBuyAdvanced) {
            for (ClickType clicktype : ClickType.values()) {
                String s = clicktype.name().toLowerCase();
                if (event.getText().contains("%price_" + s + "%") && event.getShopItem().getPriceType(clicktype).isPlayerDependend(event.getShopItem(), clicktype)) {
                    event.approveFeature();
                    return;
                }
                if (!event.getText().contains("%reward_" + s + "%") || !event.getShopItem().getRewardType(clicktype).isPlayerDependend(event.getShopItem(), clicktype)) continue;
                event.approveFeature();
                return;
            }
        }
    }
}

