/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.inbuiltaddons.logictypes;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.inbuiltaddons.logictypes.BSPricePart;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class BSPriceTypeAnd
extends BSPriceType {
    @Override
    public Object createObject(Object o, boolean force_final_state) {
        ArrayList<BSPricePart> parts = new ArrayList<BSPricePart>();
        ConfigurationSection prices = (ConfigurationSection)o;
        int i = 1;
        while (prices.contains("PriceType" + i)) {
            String priceType = prices.getString("PriceType" + i);
            Object priceObject = prices.get("Price" + i);
            BSPriceType priceT = BSPriceType.detectType(priceType);
            if (priceT == null) {
                ClassManager.manager.getBugFinder().severe("Invalid PriceType '" + priceType + "' inside price list of shopitem with pricetype AND.");
                ClassManager.manager.getBugFinder().severe("Valid PriceTypes:");
                for (BSPriceType type : BSPriceType.values()) {
                    ClassManager.manager.getBugFinder().severe("-" + type.name());
                }
            } else {
                priceT.enableType();
                Object priceO = priceT.createObject(priceObject, true);
                if (!priceT.validityCheck("?", priceO)) {
                    ClassManager.manager.getBugFinder().severe("Invalid Price '" + priceO + "' (PriceType= " + priceType + ") inside price list of shopitem with pricetype AND.");
                } else {
                    BSPricePart part = new BSPricePart(priceT, priceO);
                    parts.add(part);
                }
            }
            ++i;
        }
        return parts;
    }

    @Override
    public boolean validityCheck(String item_name, Object o) {
        if (o != null) {
            return true;
        }
        ClassManager.manager.getBugFinder().severe("Was not able to create ShopItem " + item_name + "! The price object needs to be a list of price-blocks. Every priceblock needs to contain price and pricetype.");
        return false;
    }

    @Override
    public void enableType() {
    }

    @Override
    public String[] createNames() {
        return new String[]{"and"};
    }

    @Override
    public boolean mightNeedShopUpdate() {
        return true;
    }

    @Override
    public boolean hasPrice(Player p, BSBuy buy, Object price, ClickType clickType, boolean messageOnFailure) {
        List priceparts = (List)price;
        for (BSPricePart part : priceparts) {
            if (part.getPriceType().hasPrice(p, buy, part.getPrice(), clickType, messageOnFailure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String takePrice(Player p, BSBuy buy, Object price, ClickType clickType) {
        String sep = ClassManager.manager.getMessageHandler().get("Main.ListAndSeparator");
        String s = "";
        List priceparts = (List)price;
        for (int i = 0; i < priceparts.size(); ++i) {
            BSPricePart part = (BSPricePart)priceparts.get(i);
            s = s + part.getPriceType().takePrice(p, buy, part.getPrice(), clickType) + (i < priceparts.size() - 1 ? sep : "");
        }
        return s;
    }

    @Override
    public String getDisplayPrice(Player p, BSBuy buy, Object price, ClickType clickType) {
        String sep = ClassManager.manager.getMessageHandler().get("Main.ListAndSeparator");
        String s = "";
        List priceparts = (List)price;
        for (int i = 0; i < priceparts.size(); ++i) {
            BSPricePart part = (BSPricePart)priceparts.get(i);
            s = s + part.getPriceType().getDisplayPrice(p, buy, part.getPrice(), clickType) + (i < priceparts.size() - 1 ? sep : "");
        }
        return s;
    }
}

