/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.features;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSBuy;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class TransactionLog {
    private final BossShop plugin;
    private final String fileName = "TransactionLog.yml";
    private final File file;
    private FileConfiguration config = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy dd-MM 'at' hh:mm:ss a (E)");

    public TransactionLog(BossShop plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder().getAbsolutePath(), "TransactionLog.yml");
        this.reloadConfig();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream defConfigStream = this.plugin.getResource("TransactionLog.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.file);
        }
        catch (IOException e) {
            BossShop.log("Could not save BugFinder config to " + this.file);
        }
    }

    public String getDate() {
        Date dNow = new Date();
        return this.formatter.format(dNow);
    }

    public void addTransaction(String message) {
        this.config.set(this.getDate(), (Object)message);
    }

    public void addTransaction(Player p, BSBuy buy, ClickType clicktype) {
        if (buy.getRewardType(clicktype).logTransaction()) {
            this.addTransaction("Player " + p.getName() + " bought " + buy.getName() + "(" + buy.getRewardType(clicktype).name() + ") for " + buy.getPriceType(clicktype).name() + ".");
        }
    }
}

