/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemStackChecker {
    public static final int INVENTORY_SLOT_START = 0;
    public static final int INVENTORY_SLOT_END = 35;
    private List<String> tools_suffixes = new ArrayList<String>();
    private List<Material> tools_complete;

    public ItemStackChecker() {
        this.tools_suffixes.add("AXE");
        this.tools_suffixes.add("HOE");
        this.tools_suffixes.add("PICKAXE");
        this.tools_suffixes.add("SPADE");
        this.tools_suffixes.add("SWORD");
        this.tools_suffixes.add("BOOTS");
        this.tools_suffixes.add("CHESTPLATE");
        this.tools_suffixes.add("HELMET");
        this.tools_suffixes.add("LEGGINGS");
        this.tools_suffixes.add("BARDING");
        this.tools_complete = new ArrayList<Material>();
        this.tools_complete.add(Material.BOW);
        this.tools_complete.add(Material.FLINT_AND_STEEL);
        this.tools_complete.add(Material.SHEARS);
        this.tools_complete.add(Material.FISHING_ROD);
    }

    public boolean inventoryContainsItem(Player p, ItemStack i, BSBuy buy) {
        return this.getAmountOfSameItems(p, i, buy) >= i.getAmount();
    }

    public void takeItem(ItemStack shop_item, Player p, BSBuy buy) {
        int a = 0;
        int slot = -1;
        for (ItemStack player_item : p.getInventory().getContents()) {
            if (player_item == null || player_item.getType() == Material.AIR || !this.canSell(p, player_item, shop_item, ++slot, buy)) continue;
            player_item = player_item.clone();
            player_item.setAmount(Math.min(player_item.getAmount(), shop_item.getAmount() - a));
            p.getInventory().removeItem(new ItemStack[]{player_item});
            if ((a += player_item.getAmount()) >= shop_item.getAmount()) break;
        }
        if ((a -= shop_item.getAmount()) > 0) {
            ClassManager.manager.getBugFinder().warn("Player " + p.getName() + " lost " + a + " items of type " + shop_item.getType().name() + ". How would that happen?");
        }
    }

    public int getAmountOfSameItems(Player p, ItemStack shop_item, BSBuy buy) {
        int a = 0;
        int slot = -1;
        for (ItemStack player_item : p.getInventory().getContents()) {
            if (player_item == null || !this.canSell(p, player_item, shop_item, ++slot, buy)) continue;
            a += player_item.getAmount();
        }
        return a;
    }

    public boolean hasFreeSpace(Player p, ItemStack item) {
        return this.getAmountOfFreeSpace(p, item) >= item.getAmount();
    }

    public int getAmountOfFreeSpace(Player p, ItemStack item) {
        int freeSlots = 0;
        for (int slot = 0; slot <= 35; ++slot) {
            ItemStack slotItem = p.getInventory().getItem(slot);
            if (slotItem == null || slotItem.getType() == Material.AIR) {
                freeSlots += item.getMaxStackSize();
                continue;
            }
            if (!slotItem.isSimilar(item)) continue;
            freeSlots += Math.max(0, slotItem.getMaxStackSize() - slotItem.getAmount());
        }
        return freeSlots;
    }

    public boolean hasFreeSpace(Player p, List<ItemStack> items) {
        ItemStack slotItem;
        int slot;
        HashMap<ItemStack, Integer> amounts = new HashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            int amount = item.getAmount();
            if (amounts.containsKey(item)) {
                amount += ((Integer)amounts.get(item)).intValue();
            }
            amounts.put(item, amount);
        }
        block1: for (slot = 0; slot <= 35; ++slot) {
            slotItem = p.getInventory().getItem(slot);
            if (slotItem == null) continue;
            for (ItemStack item : amounts.keySet()) {
                if (!slotItem.isSimilar(item)) continue;
                int spaceLeft = slotItem.getMaxStackSize() - slotItem.getAmount();
                int amountLeft = Math.max(0, (Integer)amounts.get(item) - spaceLeft);
                if (amountLeft == 0) {
                    amounts.remove(item);
                    continue block1;
                }
                amounts.put(item, amountLeft);
                continue block1;
            }
        }
        block3: for (slot = 0; slot <= 35; ++slot) {
            slotItem = p.getInventory().getItem(slot);
            if (slotItem != null) continue;
            for (ItemStack item : amounts.keySet()) {
                int amountLeft = (Integer)amounts.get(item);
                if (amountLeft <= 0) continue;
                if ((amountLeft = Math.max(0, amountLeft - item.getMaxStackSize())) == 0) {
                    amounts.remove(item);
                    continue block3;
                }
                amounts.put(item, amountLeft);
                continue block3;
            }
        }
        return amounts.isEmpty();
    }

    private boolean canSell(Player p, ItemStack player_item, ItemStack shop_item, int slot, BSBuy buy) {
        if (slot < 0 || slot > 35) {
            return false;
        }
        ItemDataPart exception_durability = this.isTool(player_item) && ClassManager.manager.getSettings().getAllowSellingDamagedItems() ? ItemDataPart.DURABILITY : null;
        ItemDataPart[] exceptions = new ItemDataPart[]{exception_durability};
        return ItemDataPart.isSimilar(shop_item, player_item, exceptions, buy, false, p);
    }

    public boolean isEqualShopItemAdvanced(ItemStack a, ItemStack b, boolean compare_text, Player p) {
        return this.isEqualShopItemAdvanced(a, b, compare_text, true, true, p);
    }

    public boolean isEqualShopItemAdvanced(ItemStack a, ItemStack b, boolean compare_text, boolean compare_amount, boolean compare_itemmeta_existence, Player p) {
        if (a != null && b != null) {
            if (compare_itemmeta_existence && a.hasItemMeta() != b.hasItemMeta()) {
                return false;
            }
            ItemDataPart exception_durability = this.isTool(a) && ClassManager.manager.getSettings().getAllowSellingDamagedItems() ? ItemDataPart.DURABILITY : null;
            ItemDataPart[] exceptions = !compare_text ? new ItemDataPart[]{exception_durability, ItemDataPart.NAME, ItemDataPart.LORE, ItemDataPart.PLAYERHEAD} : new ItemDataPart[]{exception_durability};
            return ItemDataPart.isSimilar(a, b, exceptions, null, compare_amount, p);
        }
        return false;
    }

    public boolean isTool(ItemStack i) {
        if (this.tools_complete.contains(i.getType())) {
            return true;
        }
        for (String tool_suffix : this.tools_suffixes) {
            if (!i.getType().name().endsWith(tool_suffix)) continue;
            return true;
        }
        return false;
    }

    public int getMaxStackSize(ItemStack i) {
        if (ClassManager.manager.getSettings().getCheckStackSize()) {
            return i.getMaxStackSize();
        }
        return 64;
    }
}

