/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.serverpinging;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.serverpinging.ServerConnector;
import org.black_ixx.bossshop.managers.serverpinging.ServerInfo;

public class ServerConnector4
implements ServerConnector {
    @Override
    public boolean update(ServerInfo info) {
        return this.ping(info);
    }

    public boolean ping(ServerInfo info) {
        try {
            Socket socket = new Socket();
            socket.connect(info.getAddress(), info.getTimeout());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.write(254);
            out.write(1);
            out.write(250);
            out.writeShort(11);
            out.writeChars("MC|PingHost");
            out.writeShort(7 + 2 * info.getHost().length());
            out.writeByte(73);
            out.writeShort(info.getHost().length());
            out.writeChars(info.getHost());
            out.writeInt(info.getPort());
            out.flush();
            if (in.read() != 255) {
                socket.close();
                throw new IOException("Bad message: An incorrect packet was received.");
            }
            int bit = in.readShort();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bit; ++i) {
                sb.append(in.readChar());
            }
            in.close();
            out.close();
            socket.close();
            String[] bits = sb.toString().split("\u0000");
            info.setMotd(bits[3]);
            info.setPlayers(Integer.valueOf(bits[4]));
            info.setMaxPlayers(Integer.valueOf(bits[5]));
            info.setOnline(true);
            return true;
        }
        catch (Exception e) {
            info.setOnline(false);
            if (ClassManager.manager.getSettings().isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

