/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.angeschossen.betterfarming.hikari.metrics.PoolStats;

class HikariCPCollector
extends Collector {
    private static final List<String> RLHXh = Collections.singletonList("pool");
    private final Map<String, PoolStats> HXvGq = new ConcurrentHashMap<String, PoolStats>();

    HikariCPCollector() {
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(this.RLHXh("hikaricp_active_connections", "Active connections", PoolStats::getActiveConnections), this.RLHXh("hikaricp_idle_connections", "Idle connections", PoolStats::getIdleConnections), this.RLHXh("hikaricp_pending_threads", "Pending threads", PoolStats::getPendingThreads), this.RLHXh("hikaricp_connections", "The number of current connections", PoolStats::getTotalConnections), this.RLHXh("hikaricp_max_connections", "Max connections", PoolStats::getMaxConnections), this.RLHXh("hikaricp_min_connections", "Min connections", PoolStats::getMinConnections));
    }

    void RLHXh(String string, PoolStats poolStats) {
        this.HXvGq.put(string, poolStats);
    }

    void RLHXh(String string) {
        this.HXvGq.remove(string);
    }

    private GaugeMetricFamily RLHXh(String string2, String string3, Function<PoolStats, Integer> function) {
        GaugeMetricFamily gaugeMetricFamily = new GaugeMetricFamily(string2, string3, RLHXh);
        this.HXvGq.forEach((string, poolStats) -> gaugeMetricFamily.addMetric(Collections.singletonList(string), (double)((Integer)function.apply((PoolStats)poolStats)).intValue()));
        return gaugeMetricFamily;
    }
}

