/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.flashback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.SuperRonanCraft.BetterRTP.player.commands.RTPCommand;
import me.SuperRonanCraft.BetterRTP.player.rtp.RTP_TYPE;
import me.SuperRonanCraft.BetterRTP.references.customEvents.RTP_TeleportPostEvent;
import me.SuperRonanCraft.BetterRTPAddons.Addon;
import me.SuperRonanCraft.BetterRTPAddons.Main;
import me.SuperRonanCraft.BetterRTPAddons.addons.flashback.FlashbackDatabase;
import me.SuperRonanCraft.BetterRTPAddons.addons.flashback.FlashbackMessages;
import me.SuperRonanCraft.BetterRTPAddons.addons.flashback.FlashbackPlayer;
import me.SuperRonanCraft.BetterRTPAddons.addons.flashback.FlashbackPlayerInfo;
import me.SuperRonanCraft.BetterRTPAddons.util.Files;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AddonFlashback
implements Addon,
Listener {
    private final String name = "Flashback";
    private Long time;
    public final FlashbackMessages msgs = new FlashbackMessages();
    public final FlashbackDatabase database = new FlashbackDatabase();
    List<FlashbackPlayer> players = new ArrayList<FlashbackPlayer>();
    HashMap<Long, String> warnings = new HashMap();

    @Override
    public boolean isEnabled() {
        return this.getFile(Files.FILETYPE.CONFIG).getBoolean("Flashback.Enabled");
    }

    @Override
    public void load() {
        Files.FILETYPE fILETYPE = this.getFile(Files.FILETYPE.CONFIG);
        this.time = fILETYPE.getConfig().getLong("Flashback.Timer.Delay");
        this.database.load(FlashbackDatabase.Columns.values());
        this.warnings.clear();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
        List list = fILETYPE.getConfig().getMapList("Flashback.Timer.Warnings");
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    Long l = this.getLong(entry.getKey().toString());
                    this.warnings.put(l, entry.getValue().toString());
                    Main.getInstance().getLogger().info("- Warnings: Time: '" + entry.getKey() + "' Message: '" + entry.getValue() + "' added");
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    System.out.println("Warning value '" + entry.getKey().toString() + "' is invalid! Please make sure to format [- INTEGER: 'Message']");
                }
            }
        }
        for (Map map : Bukkit.getOnlinePlayers()) {
            this.loadPlayer((Player)map);
        }
    }

    private Long getLong(String string) {
        return Long.valueOf(string);
    }

    @Override
    public void unload() {
        for (FlashbackPlayer flashbackPlayer : this.players) {
            flashbackPlayer.cancel();
        }
        this.players.clear();
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public RTPCommand getCmd() {
        return null;
    }

    @EventHandler
    void onTeleport(RTP_TeleportPostEvent rTP_TeleportPostEvent) {
        if (rTP_TeleportPostEvent.getType() != RTP_TYPE.ADDON_PORTAL && rTP_TeleportPostEvent.getType() != RTP_TYPE.JOIN && rTP_TeleportPostEvent.getType() != RTP_TYPE.TEST) {
            this.cancelPlayer(rTP_TeleportPostEvent.getPlayer());
            this.players.add(new FlashbackPlayer(this, rTP_TeleportPostEvent.getPlayer(), rTP_TeleportPostEvent.getOldLocation(), this.time, this.warnings));
        }
    }

    @EventHandler
    void onJoin(PlayerJoinEvent playerJoinEvent) {
        this.loadPlayer(playerJoinEvent.getPlayer());
    }

    @EventHandler
    void onLeave(PlayerQuitEvent playerQuitEvent) {
        this.cancelPlayer(playerQuitEvent.getPlayer());
    }

    private void cancelPlayer(Player player) {
        for (FlashbackPlayer flashbackPlayer : this.players) {
            if (flashbackPlayer.p != player) continue;
            flashbackPlayer.cancel();
        }
    }

    void loadPlayer(Player player) {
        FlashbackPlayerInfo flashbackPlayerInfo = this.database.getPlayer(player);
        if (flashbackPlayerInfo != null) {
            long l = (System.currentTimeMillis() - flashbackPlayerInfo.getTime()) / 1000L;
            if (l < 0L) {
                this.players.add(new FlashbackPlayer(this, player, flashbackPlayerInfo.getLocation(), l *= -1L, this.warnings));
            } else {
                this.players.add(new FlashbackPlayer(this, player, flashbackPlayerInfo.getLocation(), 0L, this.warnings));
            }
        }
    }
}

