/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.flashback;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.SuperRonanCraft.BetterRTPAddons.addons.flashback.FlashbackPlayerInfo;
import me.SuperRonanCraft.BetterRTPAddons.database.Database;
import me.SuperRonanCraft.BetterRTPAddons.database.DatabaseColumn;
import me.SuperRonanCraft.BetterRTPAddons.database.Errors;
import me.SuperRonanCraft.BetterRTPAddons.util.LocSerialization;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class FlashbackDatabase
extends Database {
    List<FlashbackPlayerInfo> playerInfos = new ArrayList<FlashbackPlayerInfo>();
    private final String createTable = "CREATE TABLE IF NOT EXISTS BRTP_Data (`" + Columns.access$000(Columns.UUID) + "` " + Columns.access$100(Columns.UUID) + " PRIMARY KEY NOT NULL,`" + Columns.access$000(Columns.NAME) + "` " + Columns.access$100(Columns.NAME) + ",`" + Columns.access$000(Columns.LOCATION_OLD) + "` " + Columns.access$100(Columns.LOCATION_OLD) + " NOT NULL,`" + Columns.access$000(Columns.TIME_GOAL) + "` " + Columns.access$100(Columns.LOCATION_OLD) + " NOT NULL);";

    public FlashbackDatabase() {
        super("addon_flashback");
    }

    @Override
    public String getTableFormat() {
        return this.createTable;
    }

    @Override
    public void load(DatabaseColumn[] databaseColumnArray) {
        this.playerInfos.clear();
        super.load(databaseColumnArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlashbackPlayerInfo getPlayer(Player player) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("SELECT * FROM BRTP_Data WHERE " + Columns.UUID.name + " = ?");
            UUID uUID = player.getUniqueId();
            preparedStatement.setString(1, uUID.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Location location = LocSerialization.getLocationFromString(resultSet.getString(Columns.LOCATION_OLD.name));
                Long l = resultSet.getLong(Columns.TIME_GOAL.name);
                FlashbackPlayerInfo flashbackPlayerInfo = new FlashbackPlayerInfo(player, location, l);
                this.close(preparedStatement, resultSet, connection);
                return flashbackPlayerInfo;
            }
            this.close(preparedStatement, resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
        }
        finally {
            this.close(preparedStatement, resultSet, connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPlayer(Player player, Location location, Long l) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO BRTP_Data(" + Columns.UUID.name + ", " + Columns.TIME_GOAL.name + ", " + Columns.LOCATION_OLD.name + ") VALUES (?, ?, ?) ON CONFLICT(" + Columns.UUID.name + ") DO UPDATE SET " + Columns.TIME_GOAL.name + " = + ?, " + Columns.LOCATION_OLD.name + " = + ?");
            UUID uUID = player.getUniqueId();
            preparedStatement.setString(1, uUID.toString());
            preparedStatement.setLong(2, l);
            String string = LocSerialization.getStringFromLocation(location);
            preparedStatement.setString(3, string);
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, string);
            preparedStatement.executeUpdate();
            this.close(preparedStatement, null, connection);
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
            bl = false;
        }
        finally {
            this.close(preparedStatement, null, connection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(Player player) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM BRTP_Data WHERE " + Columns.UUID.name + " = ?");
            UUID uUID = player.getUniqueId();
            preparedStatement.setString(1, uUID.toString());
            preparedStatement.executeUpdate();
            this.close(preparedStatement, null, connection);
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
        }
        finally {
            this.close(preparedStatement, null, connection);
        }
    }

    static enum Columns implements DatabaseColumn
    {
        UUID("uuid", "varchar(32)"),
        NAME("player", "varchar(16)"),
        LOCATION_OLD("location_old", "longtext"),
        TIME_GOAL("time_goal", "bigint(19)");

        private final String name;
        private final String type;

        private Columns(String string2, String string3) {
            this.name = string2;
            this.type = string3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        static /* synthetic */ String access$100(Columns columns) {
            return columns.type;
        }
    }
}

