/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.logger;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import me.SuperRonanCraft.BetterRTP.BetterRTP;
import me.SuperRonanCraft.BetterRTP.player.commands.RTPCommand;
import me.SuperRonanCraft.BetterRTP.player.commands.types.CmdReload;
import me.SuperRonanCraft.BetterRTP.references.customEvents.RTP_CommandEvent;
import me.SuperRonanCraft.BetterRTP.references.customEvents.RTP_CommandEvent_After;
import me.SuperRonanCraft.BetterRTP.references.customEvents.RTP_TeleportPostEvent;
import me.SuperRonanCraft.BetterRTPAddons.Addon;
import me.SuperRonanCraft.BetterRTPAddons.Main;
import me.SuperRonanCraft.BetterRTPAddons.addons.logger.LoggerDatabase;
import me.SuperRonanCraft.BetterRTPAddons.util.Files;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class AddonLogger
implements Addon,
Listener {
    private final String name = "Logger";
    private String format;
    private boolean toConsole;
    Logger logger;
    FileHandler handler;
    ConsoleHandler consoleHandler_rtp;
    ConsoleHandler consoleHandler_main;
    private final LoggerDatabase database = new LoggerDatabase();

    @Override
    public boolean isEnabled() {
        return this.getFile(Files.FILETYPE.CONFIG).getBoolean("Logger.Enabled");
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
        this.format = this.getFile(Files.FILETYPE.CONFIG).getString("Logger.Format");
        this.toConsole = this.getFile(Files.FILETYPE.CONFIG).getBoolean("Logger.LogToConsole");
        try {
            File file = new File(Main.getInstance().getDataFolder() + File.separator + "log.txt");
            this.handler = new FileHandler(file.getPath(), true);
            this.handler.setFormatter(new MyFormatter(this));
            this.logger = Logger.getLogger(Main.getInstance().getName() + "-Log");
            this.logger.setUseParentHandlers(this.toConsole);
            this.logger.addHandler(this.handler);
            this.consoleHandler_rtp = new MyConsole(this.logger, BetterRTP.getInstance().getName());
            BetterRTP.getInstance().getLogger().addHandler(this.consoleHandler_rtp);
            this.consoleHandler_main = new MyConsole(this.logger, Main.getInstance().getName());
            Main.getInstance().getLogger().addHandler(this.consoleHandler_main);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.database.load(LoggerDatabase.Columns.values());
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this);
        this.logger.removeHandler(this.handler);
        this.handler.close();
        BetterRTP.getInstance().getLogger().removeHandler(this.consoleHandler_rtp);
        Main.getInstance().getLogger().removeHandler(this.consoleHandler_main);
    }

    @Override
    public RTPCommand getCmd() {
        return null;
    }

    @EventHandler
    public void onCmd(RTP_CommandEvent rTP_CommandEvent) {
        if (rTP_CommandEvent instanceof RTP_CommandEvent_After) {
            return;
        }
        String string = rTP_CommandEvent.getSendi().getName() + " executed `/rtp " + rTP_CommandEvent.getCmd().getName() + "` at " + this.getDate();
        Level level = Level.INFO;
        if (rTP_CommandEvent.getCmd() instanceof CmdReload) {
            level = Level.WARNING;
        }
        this.log(string, level);
    }

    @EventHandler
    public void onTeleport(RTP_TeleportPostEvent rTP_TeleportPostEvent) {
        String string = rTP_TeleportPostEvent.getPlayer().getName() + " has teleported to " + rTP_TeleportPostEvent.getLocation().toString() + " in world " + rTP_TeleportPostEvent.getLocation().getWorld().getName() + " at" + this.getDate();
        this.log(string, Level.INFO);
        this.database.log(rTP_TeleportPostEvent.getPlayer(), rTP_TeleportPostEvent.getOldLocation(), rTP_TeleportPostEvent.getLocation());
    }

    private void log(String string, Level level) {
        this.logger.log(level, string);
    }

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
        return simpleDateFormat.format(new Date());
    }

    static class MyFormatter
    extends Formatter {
        AddonLogger addon;

        MyFormatter(AddonLogger addonLogger) {
            this.addon = addonLogger;
        }

        @Override
        public String format(LogRecord logRecord) {
            return this.addon.getDate() + " [" + logRecord.getLevel().getName() + "]: " + logRecord.getMessage() + '\n';
        }
    }

    static class MyConsole
    extends ConsoleHandler {
        Level lvl;
        Logger logger;

        MyConsole(Logger logger, String string) {
            this.logger = logger;
            this.lvl = new MyLevel(string, Integer.MAX_VALUE);
        }

        @Override
        public void publish(LogRecord logRecord) {
            this.logger.log(this.lvl, logRecord.getMessage());
        }
    }

    static class MyLevel
    extends Level {
        protected MyLevel(String string, int n) {
            super(string, n);
        }
    }
}

