/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.portals;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.SuperRonanCraft.BetterRTPAddons.addons.portals.region.PortalsRegionInfo;
import me.SuperRonanCraft.BetterRTPAddons.database.Database;
import me.SuperRonanCraft.BetterRTPAddons.database.DatabaseColumn;
import me.SuperRonanCraft.BetterRTPAddons.database.Errors;
import me.SuperRonanCraft.BetterRTPAddons.util.LocSerialization;

public class PortalsDatabase
extends Database {
    private final String createTable = "CREATE TABLE IF NOT EXISTS BRTP_Data (`" + Columns.access$000(Columns.NAME) + "` " + Columns.access$100(Columns.NAME) + " PRIMARY KEY,`" + Columns.access$000(Columns.LOCATION_1) + "` " + Columns.access$100(Columns.LOCATION_2) + ",`" + Columns.access$000(Columns.LOCATION_2) + "` " + Columns.access$100(Columns.LOCATION_2) + ",`" + Columns.access$000(Columns.WORLD) + "` " + Columns.access$100(Columns.WORLD) + ");";

    public PortalsDatabase() {
        super("addon_portals");
    }

    @Override
    public String getTableFormat() {
        return this.createTable;
    }

    @Override
    public void load(DatabaseColumn[] databaseColumnArray) {
        super.load(databaseColumnArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<PortalsRegionInfo> getPortals() {
        Object object;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("SELECT * FROM BRTP_Data");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (resultSet.next()) {
                object = new PortalsRegionInfo();
                ((PortalsRegionInfo)object).setLoc1(LocSerialization.getLocationFromString(resultSet.getString(Columns.LOCATION_1.name)));
                ((PortalsRegionInfo)object).setLoc2(LocSerialization.getLocationFromString(resultSet.getString(Columns.LOCATION_2.name)));
                ((PortalsRegionInfo)object).setName(resultSet.getString(Columns.NAME.name));
                ((PortalsRegionInfo)object).setWorld(resultSet.getString(Columns.WORLD.name));
                arrayList.add(object);
            }
            object = arrayList;
        }
        catch (SQLException sQLException) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, resultSet, connection);
                throw throwable;
            }
            this.close(preparedStatement, resultSet, connection);
            return null;
        }
        this.close(preparedStatement, resultSet, connection);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePortal(PortalsRegionInfo portalsRegionInfo) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM BRTP_Data WHERE " + Columns.NAME.name + " = ?");
            preparedStatement.setString(1, portalsRegionInfo.getName());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
                bl = false;
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, null, connection);
                throw throwable;
            }
            this.close(preparedStatement, null, connection);
        }
        this.close(preparedStatement, null, connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPortal(PortalsRegionInfo portalsRegionInfo) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO BRTP_Data(" + Columns.NAME.name + ", " + Columns.LOCATION_1.name + ", " + Columns.LOCATION_2.name + ", " + Columns.WORLD.name + ") VALUES (?, ?, ?, ?) ON CONFLICT(" + Columns.NAME.name + ") DO UPDATE SET " + Columns.LOCATION_1.name + " = ?, " + Columns.LOCATION_2.name + " = ?, " + Columns.WORLD.name + " = ?");
            preparedStatement.setString(1, portalsRegionInfo.getName());
            String string = LocSerialization.getStringFromLocation(portalsRegionInfo.getLoc1());
            String string2 = LocSerialization.getStringFromLocation(portalsRegionInfo.getLoc2());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, portalsRegionInfo.getWorld());
            preparedStatement.setString(5, string);
            preparedStatement.setString(6, string2);
            preparedStatement.setString(7, portalsRegionInfo.getWorld());
            preparedStatement.executeUpdate();
            this.close(preparedStatement, null, connection);
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), sQLException);
            bl = false;
        }
        finally {
            this.close(preparedStatement, null, connection);
        }
        return bl;
    }

    static enum Columns implements DatabaseColumn
    {
        LOCATION_1("location_1", "longtext"),
        LOCATION_2("location_2", "longtext"),
        NAME("name", "varchar(255)"),
        WORLD("world", "text");

        private final String name;
        private final String type;

        private Columns(String string2, String string3) {
            this.name = string2;
            this.type = string3;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        static /* synthetic */ String access$100(Columns columns) {
            return columns.type;
        }
    }
}

