/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.database;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.SuperRonanCraft.BetterRTPAddons.Main;
import me.SuperRonanCraft.BetterRTPAddons.database.DatabaseColumn;
import me.SuperRonanCraft.BetterRTPAddons.database.Error;

public abstract class Database {
    public String console_id = "CONSOLE";
    public Connection connection;
    public Main plugin = Main.getInstance();
    public String db_name;
    public final String table = "BRTP_Data";

    public Database(String string) {
        this.db_name = string;
    }

    protected Connection getSQLConnection() {
        File file = new File(this.plugin.getDataFolder().getPath() + File.separator + "data", this.db_name + ".db");
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException iOException) {
                this.plugin.getLogger().log(Level.SEVERE, "File write error: " + this.db_name + ".db");
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
            return this.connection;
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite exception on initialize", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.plugin.getLogger().log(Level.SEVERE, "You need the SQLite JBDC library. Google it. Put it in /lib folder.");
        }
        return null;
    }

    public abstract String getTableFormat();

    public void load(DatabaseColumn[] databaseColumnArray) {
        this.connection = this.getSQLConnection();
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(this.getTableFormat());
            for (DatabaseColumn databaseColumn : databaseColumnArray) {
                try {
                    String string = "ALTER TABLE BRTP_Data ADD COLUMN %column% %type%";
                    statement.executeUpdate(string.replace("%column%", databaseColumn.getName()).replace("%type%", databaseColumn.getType()));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.initialize(databaseColumnArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DatabaseColumn databaseColumn) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLConnection();
            preparedStatement = connection.prepareStatement("SELECT * FROM BRTP_Data WHERE " + databaseColumn.getName() + " = ?");
            preparedStatement.setString(1, "");
            resultSet = preparedStatement.executeQuery();
            this.close(preparedStatement, resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to retreive connection", sQLException);
        }
        finally {
            this.close(preparedStatement, resultSet, connection);
        }
    }

    protected void close(PreparedStatement preparedStatement, ResultSet resultSet, Connection connection) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Error.close(this.plugin, sQLException);
        }
    }
}

