/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.paperlib.environments;

import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.asyncchunks.AsyncChunks;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.asyncchunks.AsyncChunksSync;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.asyncteleport.AsyncTeleport;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.asyncteleport.AsyncTeleportSync;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.bedspawnlocation.BedSpawnLocation;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.bedspawnlocation.BedSpawnLocationSync;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.blockstatesnapshot.BlockStateSnapshot;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.blockstatesnapshot.BlockStateSnapshotBeforeSnapshots;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.blockstatesnapshot.BlockStateSnapshotNoOption;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.chunkisgenerated.ChunkIsGenerated;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.chunkisgenerated.ChunkIsGeneratedApiExists;
import me.SuperRonanCraft.BetterRTPAddons.paperlib.features.chunkisgenerated.ChunkIsGeneratedUnknown;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Environment {
    private int minecraftVersion;
    private int minecraftPatchVersion;
    protected AsyncChunks asyncChunksHandler = new AsyncChunksSync();
    protected AsyncTeleport asyncTeleportHandler = new AsyncTeleportSync();
    protected ChunkIsGenerated isGeneratedHandler = new ChunkIsGeneratedUnknown();
    protected BlockStateSnapshot blockStateSnapshotHandler;
    protected BedSpawnLocation bedSpawnLocationHandler = new BedSpawnLocationSync();

    public Environment() {
        Pattern pattern = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?\\)");
        Matcher matcher = pattern.matcher(Bukkit.getVersion());
        int n = 0;
        int n2 = 0;
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            try {
                n = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (matchResult.groupCount() >= 3) {
                try {
                    n2 = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.minecraftVersion = n;
        this.minecraftPatchVersion = n2;
        if (this.isVersion(13, 1)) {
            this.isGeneratedHandler = new ChunkIsGeneratedApiExists();
        }
        this.blockStateSnapshotHandler = !this.isVersion(12) ? new BlockStateSnapshotBeforeSnapshots() : new BlockStateSnapshotNoOption();
    }

    public abstract String getName();

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n, int n2, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n, n2, bl, false);
    }

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n, int n2, boolean bl, boolean bl2) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n, n2, bl, bl2);
    }

    public CompletableFuture<Chunk> getChunkAtAsyncUrgently(World world, int n, int n2, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n, n2, bl, true);
    }

    public CompletableFuture<Boolean> teleport(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.asyncTeleportHandler.teleportAsync(entity, location, teleportCause);
    }

    public boolean isChunkGenerated(World world, int n, int n2) {
        return this.isGeneratedHandler.isChunkGenerated(world, n, n2);
    }

    public BlockStateSnapshotResult getBlockState(Block block, boolean bl) {
        return this.blockStateSnapshotHandler.getBlockState(block, bl);
    }

    public CompletableFuture<Location> getBedSpawnLocationAsync(Player player, boolean bl) {
        return this.bedSpawnLocationHandler.getBedSpawnLocationAsync(player, bl);
    }

    public boolean isVersion(int n) {
        return this.isVersion(n, 0);
    }

    public boolean isVersion(int n, int n2) {
        return this.minecraftVersion > n || this.minecraftVersion >= n && this.minecraftPatchVersion >= n2;
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getMinecraftPatchVersion() {
        return this.minecraftPatchVersion;
    }

    public boolean isSpigot() {
        return false;
    }

    public boolean isPaper() {
        return false;
    }
}

