/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import me.angeschossen.chestprotect.hikari.HikariConfig;
import me.angeschossen.chestprotect.hikari.HikariDataSource;
import me.angeschossen.chestprotect.hikari.util.PropertyElf;

public class HikariJNDIFactory
implements ObjectFactory {
    public synchronized Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) {
        if (object instanceof Reference && "javax.sql.DataSource".equals(((Reference)object).getClassName())) {
            Reference reference = (Reference)object;
            Set set = PropertyElf.getPropertyNames(HikariConfig.class);
            Properties properties = new Properties();
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                RefAddr refAddr = enumeration.nextElement();
                String string = refAddr.getType();
                if (!string.startsWith("dataSource.") && !set.contains(string)) continue;
                properties.setProperty(string, refAddr.getContent().toString());
            }
            return this.createDataSource(properties, context);
        }
        return null;
    }

    private DataSource createDataSource(Properties properties, Context context) {
        String string = properties.getProperty("dataSourceJNDI");
        if (string != null) {
            return this.lookupJndiDataSource(properties, context, string);
        }
        return new HikariDataSource(new HikariConfig(properties));
    }

    private DataSource lookupJndiDataSource(Properties properties, Context context, String string) {
        Object object;
        if (context == null) {
            throw new RuntimeException("JNDI context does not found for dataSourceJNDI : " + string);
        }
        DataSource dataSource = (DataSource)context.lookup(string);
        if (dataSource == null) {
            object = new InitialContext();
            dataSource = (DataSource)object.lookup(string);
            object.close();
        }
        if (dataSource != null) {
            object = new HikariConfig(properties);
            ((HikariConfig)object).setDataSource(dataSource);
            return new HikariDataSource((HikariConfig)object);
        }
        return null;
    }
}

