/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.angeschossen.chestprotect.hikari.HikariConfig;
import me.angeschossen.chestprotect.slf4j.Logger;
import me.angeschossen.chestprotect.slf4j.LoggerFactory;

public final class PropertyElf {
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)[A-Z].+");

    private PropertyElf() {
    }

    public static void setTargetFromProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            return;
        }
        List<Method> list = Arrays.asList(object.getClass().getMethods());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object2, object3) -> {
            if (object instanceof HikariConfig && object2.toString().startsWith("dataSource.")) {
                ((HikariConfig)object).addDataSourceProperty(object2.toString().substring("dataSource.".length()), object3);
            } else {
                PropertyElf.setProperty(object, object2.toString(), object3, list);
            }
        }));
    }

    public static Set getPropertyNames(Class clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        Matcher matcher = GETTER_PATTERN.matcher("");
        for (Method method : clazz.getMethods()) {
            String string = method.getName();
            if (method.getParameterTypes().length != 0 || !matcher.reset(string).matches()) continue;
            string = string.replaceFirst("(get|is)", "");
            try {
                if (clazz.getMethod("set" + string, method.getReturnType()) == null) continue;
                string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                hashSet.add(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public static Object getProperty(String string, Object object) {
        try {
            String string2 = "get" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
            Method method = object.getClass().getMethod(string2, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            try {
                String string3 = "is" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                Method method = object.getClass().getMethod(string3, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static Properties copyProperties(Properties properties) {
        Properties properties2 = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> properties2.setProperty(object.toString(), object2.toString())));
        return properties2;
    }

    private static void setProperty(Object object, String string, Object object2, List list) {
        Object object3;
        Logger logger = LoggerFactory.getLogger(PropertyElf.class);
        String string2 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
        Method method2 = list.stream().filter(method -> method.getName().equals(string2) && method.getParameterCount() == 1).findFirst().orElse(null);
        if (method2 == null) {
            object3 = "set" + string.toUpperCase(Locale.ENGLISH);
            method2 = list.stream().filter(arg_0 -> PropertyElf.lambda$setProperty$3((String)object3, arg_0)).findFirst().orElse(null);
        }
        if (method2 == null) {
            logger.error("Property {} does not exist on target {}", (Object)string, (Object)object.getClass());
            throw new RuntimeException(String.format("Property %s does not exist on target %s", string, object.getClass()));
        }
        try {
            object3 = method2.getParameterTypes()[0];
            if (object3 == Integer.TYPE) {
                method2.invoke(object, Integer.parseInt(object2.toString()));
            } else if (object3 == Long.TYPE) {
                method2.invoke(object, Long.parseLong(object2.toString()));
            } else if (object3 == Short.TYPE) {
                method2.invoke(object, Short.parseShort(object2.toString()));
            } else if (object3 == Boolean.TYPE || object3 == Boolean.class) {
                method2.invoke(object, Boolean.parseBoolean(object2.toString()));
            } else if (object3 == String.class) {
                method2.invoke(object, object2.toString());
            } else {
                try {
                    logger.debug("Try to create a new instance of \"{}\"", object2);
                    method2.invoke(object, Class.forName(object2.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
                    logger.debug("Class \"{}\" not found or could not instantiate it (Default constructor)", object2);
                    method2.invoke(object, object2);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Failed to set property {} on target {}", string, object.getClass(), exception);
            throw new RuntimeException(exception);
        }
    }

    private static /* synthetic */ boolean lambda$setProperty$3(String string, Method method) {
        return method.getName().equals(string) && method.getParameterCount() == 1;
    }
}

