/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.slf4j.event;

import java.util.Queue;
import me.angeschossen.chestprotect.slf4j.Logger;
import me.angeschossen.chestprotect.slf4j.Marker;
import me.angeschossen.chestprotect.slf4j.event.Level;
import me.angeschossen.chestprotect.slf4j.event.SubstituteLoggingEvent;
import me.angeschossen.chestprotect.slf4j.helpers.MessageFormatter;
import me.angeschossen.chestprotect.slf4j.helpers.SubstituteLogger;

public class EventRecodingLogger
implements Logger {
    String name;
    SubstituteLogger logger;
    Queue eventQueue;
    static final boolean RECORD_ALL_EVENTS = true;

    public EventRecodingLogger(SubstituteLogger substituteLogger, Queue queue) {
        this.logger = substituteLogger;
        this.name = substituteLogger.getName();
        this.eventQueue = queue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String string) {
        this.recordEvent_0Args(Level.TRACE, null, string, null);
    }

    public void trace(String string, Object object) {
        this.recordEvent_1Args(Level.TRACE, null, string, object);
    }

    public void trace(String string, Object object, Object object2) {
        this.recordEvent2Args(Level.TRACE, null, string, object, object2);
    }

    public void trace(String string, Object ... objectArray) {
        this.recordEventArgArray(Level.TRACE, null, string, objectArray);
    }

    public void trace(String string, Throwable throwable) {
        this.recordEvent_0Args(Level.TRACE, null, string, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public void trace(Marker marker, String string) {
        this.recordEvent_0Args(Level.TRACE, marker, string, null);
    }

    public void trace(Marker marker, String string, Object object) {
        this.recordEvent_1Args(Level.TRACE, marker, string, object);
    }

    public void trace(Marker marker, String string, Object object, Object object2) {
        this.recordEvent2Args(Level.TRACE, marker, string, object, object2);
    }

    public void trace(Marker marker, String string, Object ... objectArray) {
        this.recordEventArgArray(Level.TRACE, marker, string, objectArray);
    }

    public void trace(Marker marker, String string, Throwable throwable) {
        this.recordEvent_0Args(Level.TRACE, marker, string, throwable);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String string) {
        this.recordEvent_0Args(Level.DEBUG, null, string, null);
    }

    public void debug(String string, Object object) {
        this.recordEvent_1Args(Level.DEBUG, null, string, object);
    }

    public void debug(String string, Object object, Object object2) {
        this.recordEvent2Args(Level.DEBUG, null, string, object, object2);
    }

    public void debug(String string, Object ... objectArray) {
        this.recordEventArgArray(Level.DEBUG, null, string, objectArray);
    }

    public void debug(String string, Throwable throwable) {
        this.recordEvent_0Args(Level.DEBUG, null, string, throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public void debug(Marker marker, String string) {
        this.recordEvent_0Args(Level.DEBUG, marker, string, null);
    }

    public void debug(Marker marker, String string, Object object) {
        this.recordEvent_1Args(Level.DEBUG, marker, string, object);
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.recordEvent2Args(Level.DEBUG, marker, string, object, object2);
    }

    public void debug(Marker marker, String string, Object ... objectArray) {
        this.recordEventArgArray(Level.DEBUG, marker, string, objectArray);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.recordEvent_0Args(Level.DEBUG, marker, string, throwable);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String string) {
        this.recordEvent_0Args(Level.INFO, null, string, null);
    }

    public void info(String string, Object object) {
        this.recordEvent_1Args(Level.INFO, null, string, object);
    }

    public void info(String string, Object object, Object object2) {
        this.recordEvent2Args(Level.INFO, null, string, object, object2);
    }

    public void info(String string, Object ... objectArray) {
        this.recordEventArgArray(Level.INFO, null, string, objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.recordEvent_0Args(Level.INFO, null, string, throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(Marker marker, String string) {
        this.recordEvent_0Args(Level.INFO, marker, string, null);
    }

    public void info(Marker marker, String string, Object object) {
        this.recordEvent_1Args(Level.INFO, marker, string, object);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.recordEvent2Args(Level.INFO, marker, string, object, object2);
    }

    public void info(Marker marker, String string, Object ... objectArray) {
        this.recordEventArgArray(Level.INFO, marker, string, objectArray);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.recordEvent_0Args(Level.INFO, marker, string, throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String string) {
        this.recordEvent_0Args(Level.WARN, null, string, null);
    }

    public void warn(String string, Object object) {
        this.recordEvent_1Args(Level.WARN, null, string, object);
    }

    public void warn(String string, Object object, Object object2) {
        this.recordEvent2Args(Level.WARN, null, string, object, object2);
    }

    public void warn(String string, Object ... objectArray) {
        this.recordEventArgArray(Level.WARN, null, string, objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.recordEvent_0Args(Level.WARN, null, string, throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String string) {
        this.recordEvent_0Args(Level.WARN, marker, string, null);
    }

    public void warn(Marker marker, String string, Object object) {
        this.recordEvent_1Args(Level.WARN, marker, string, object);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.recordEvent2Args(Level.WARN, marker, string, object, object2);
    }

    public void warn(Marker marker, String string, Object ... objectArray) {
        this.recordEventArgArray(Level.WARN, marker, string, objectArray);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.recordEvent_0Args(Level.WARN, marker, string, throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String string) {
        this.recordEvent_0Args(Level.ERROR, null, string, null);
    }

    public void error(String string, Object object) {
        this.recordEvent_1Args(Level.ERROR, null, string, object);
    }

    public void error(String string, Object object, Object object2) {
        this.recordEvent2Args(Level.ERROR, null, string, object, object2);
    }

    public void error(String string, Object ... objectArray) {
        this.recordEventArgArray(Level.ERROR, null, string, objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.recordEvent_0Args(Level.ERROR, null, string, throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String string) {
        this.recordEvent_0Args(Level.ERROR, marker, string, null);
    }

    public void error(Marker marker, String string, Object object) {
        this.recordEvent_1Args(Level.ERROR, marker, string, object);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.recordEvent2Args(Level.ERROR, marker, string, object, object2);
    }

    public void error(Marker marker, String string, Object ... objectArray) {
        this.recordEventArgArray(Level.ERROR, marker, string, objectArray);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.recordEvent_0Args(Level.ERROR, marker, string, throwable);
    }

    private void recordEvent_0Args(Level level, Marker marker, String string, Throwable throwable) {
        this.recordEvent(level, marker, string, null, throwable);
    }

    private void recordEvent_1Args(Level level, Marker marker, String string, Object object) {
        this.recordEvent(level, marker, string, new Object[]{object}, null);
    }

    private void recordEvent2Args(Level level, Marker marker, String string, Object object, Object object2) {
        if (object2 instanceof Throwable) {
            this.recordEvent(level, marker, string, new Object[]{object}, (Throwable)object2);
        } else {
            this.recordEvent(level, marker, string, new Object[]{object, object2}, null);
        }
    }

    private void recordEventArgArray(Level level, Marker marker, String string, Object[] objectArray) {
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        if (throwable != null) {
            Object[] objectArray2 = MessageFormatter.trimmedCopy(objectArray);
            this.recordEvent(level, marker, string, objectArray2, throwable);
        } else {
            this.recordEvent(level, marker, string, objectArray, null);
        }
    }

    private void recordEvent(Level level, Marker marker, String string, Object[] objectArray, Throwable throwable) {
        SubstituteLoggingEvent substituteLoggingEvent = new SubstituteLoggingEvent();
        substituteLoggingEvent.setTimeStamp(System.currentTimeMillis());
        substituteLoggingEvent.setLevel(level);
        substituteLoggingEvent.setLogger(this.logger);
        substituteLoggingEvent.setLoggerName(this.name);
        substituteLoggingEvent.setMarker(marker);
        substituteLoggingEvent.setMessage(string);
        substituteLoggingEvent.setThreadName(Thread.currentThread().getName());
        substituteLoggingEvent.setArgumentArray(objectArray);
        substituteLoggingEvent.setThrowable(throwable);
        this.eventQueue.add(substituteLoggingEvent);
    }
}

