/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant;

import com.google.common.collect.HashBiMap;
import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.eco.core.registry.Registry;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.display.EnchantmentFormattingKt;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.MissingDependencyException;
import com.willfp.ecoenchants.enchant.MissingDependencyExceptionKt;
import com.willfp.ecoenchants.enchant.impl.EcoEnchantBase;
import com.willfp.ecoenchants.enchant.impl.HardcodedEcoEnchant;
import com.willfp.ecoenchants.enchant.impl.LibreforgeEcoEnchant;
import com.willfp.ecoenchants.enchant.impl.hardcoded.EnchantmentPermanenceCurse;
import com.willfp.ecoenchants.enchant.impl.hardcoded.EnchantmentRepairing;
import com.willfp.ecoenchants.enchant.impl.hardcoded.EnchantmentReplenish;
import com.willfp.ecoenchants.enchant.impl.hardcoded.EnchantmentSoulbound;
import com.willfp.ecoenchants.enchant.registration.EnchantmentRegisterer;
import com.willfp.ecoenchants.enchant.registration.modern.ModernEnchantmentRegistererProxy;
import com.willfp.ecoenchants.integrations.EnchantRegistrations;
import com.willfp.ecoenchants.libreforge.loader.LibreforgePlugin;
import com.willfp.ecoenchants.libreforge.loader.configs.RegistrableCategory;
import com.willfp.ecoenchants.rarity.EnchantmentRarities;
import com.willfp.ecoenchants.target.EnchantmentTargets;
import com.willfp.ecoenchants.type.EnchantmentTypes;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002RN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u0002 \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/willfp/ecoenchants/enchant/EcoEnchants;", "Lcom/willfp/ecoenchants/libreforge/loader/configs/RegistrableCategory;", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "()V", "BY_NAME", "Lcom/google/common/collect/HashBiMap;", "", "kotlin.jvm.PlatformType", "shouldPreload", "", "getShouldPreload", "()Z", "acceptConfig", "", "plugin", "Lcom/willfp/ecoenchants/libreforge/loader/LibreforgePlugin;", "id", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "acceptPreloadConfig", "afterReload", "beforeReload", "clear", "doRegister", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "enchant", "Lcom/willfp/ecoenchants/enchant/impl/EcoEnchantBase;", "getByName", "name", "registerHardcodedEnchantments", "core-plugin"})
public final class EcoEnchants
extends RegistrableCategory<EcoEnchant> {
    @NotNull
    public static final EcoEnchants INSTANCE = new EcoEnchants();
    private static final HashBiMap<String, EcoEnchant> BY_NAME = HashBiMap.create();
    private static final boolean shouldPreload = true;

    private EcoEnchants() {
        super("enchant", "enchants");
    }

    @Override
    public boolean getShouldPreload() {
        return shouldPreload;
    }

    @Override
    public void clear(@NotNull LibreforgePlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        EcoEnchantsPlugin cfr_ignored_0 = (EcoEnchantsPlugin)plugin;
        for (EcoEnchant enchant : this.getRegistry().values()) {
            EnchantmentRegisterer enchantmentRegisterer = ((EcoEnchantsPlugin)plugin).getEnchantmentRegisterer();
            Intrinsics.checkNotNull((Object)enchant);
            enchantmentRegisterer.unregister(enchant);
            EnchantRegistrations.INSTANCE.removeEnchant(enchant);
            BY_NAME.remove((Object)EnchantmentFormattingKt.getFormattedName$default(enchant, 0, false, 2, null));
        }
        this.getRegistry().clear();
    }

    @Override
    public void beforeReload(@NotNull LibreforgePlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        if (Prerequisite.HAS_1_20_3.isMet()) {
            ((ModernEnchantmentRegistererProxy)plugin.getProxy(ModernEnchantmentRegistererProxy.class)).replaceRegistry();
        }
        EcoEnchantsPlugin cfr_ignored_0 = (EcoEnchantsPlugin)plugin;
        EnchantmentRarities.update((EcoEnchantsPlugin)plugin);
        EnchantmentTargets.update((EcoEnchantsPlugin)plugin);
        EnchantmentTypes.INSTANCE.update((EcoEnchantsPlugin)plugin);
    }

    @Override
    public void afterReload(@NotNull LibreforgePlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        EcoEnchantsPlugin cfr_ignored_0 = (EcoEnchantsPlugin)plugin;
        MissingDependencyExceptionKt.sendPrompts(plugin);
        this.registerHardcodedEnchantments((EcoEnchantsPlugin)plugin);
    }

    @Override
    public void acceptPreloadConfig(@NotNull LibreforgePlugin plugin, @NotNull String id, @NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        EcoEnchantsPlugin cfr_ignored_0 = (EcoEnchantsPlugin)plugin;
        if (!config2.has("effects")) {
            return;
        }
        try {
            LibreforgeEcoEnchant enchant = new LibreforgeEcoEnchant(id, config2, (EcoEnchantsPlugin)plugin);
            this.doRegister((EcoEnchantsPlugin)plugin, enchant);
        }
        catch (MissingDependencyException missingDependencyException) {
            // empty catch block
        }
    }

    @Override
    public void acceptConfig(@NotNull LibreforgePlugin plugin, @NotNull String id, @NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        EcoEnchantsPlugin cfr_ignored_0 = (EcoEnchantsPlugin)plugin;
        if (!config2.has("effects")) {
            return;
        }
        try {
            LibreforgeEcoEnchant enchant = new LibreforgeEcoEnchant(id, config2, (EcoEnchantsPlugin)plugin);
            this.doRegister((EcoEnchantsPlugin)plugin, enchant);
        }
        catch (MissingDependencyException e) {
            MissingDependencyExceptionKt.addPluginPrompt((EcoEnchantsPlugin)plugin, e.getPlugins());
        }
    }

    private final void doRegister(EcoEnchantsPlugin plugin, EcoEnchantBase enchant) {
        Enchantment enchantment = plugin.getEnchantmentRegisterer().register(enchant);
        Registry registry = this.getRegistry();
        Intrinsics.checkNotNull((Object)enchantment, (String)"null cannot be cast to non-null type com.willfp.ecoenchants.enchant.EcoEnchant");
        registry.register((Registrable)((EcoEnchant)enchantment));
        HashBiMap<String, EcoEnchant> hashBiMap = BY_NAME;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"BY_NAME");
        Map map = (Map)hashBiMap;
        String string = ChatColor.stripColor((String)EnchantmentFormattingKt.getFormattedName$default(enchant, 0, false, 2, null));
        EcoEnchant ecoEnchant = (EcoEnchant)enchantment;
        map.put(string, ecoEnchant);
        EnchantRegistrations.INSTANCE.registerEnchantments$core_plugin();
    }

    private final void registerHardcodedEnchantments(EcoEnchantsPlugin plugin) {
        HardcodedEcoEnchant[] hardcodedEcoEnchantArray = new HardcodedEcoEnchant[]{new EnchantmentPermanenceCurse(plugin), new EnchantmentRepairing(plugin), new EnchantmentReplenish(plugin), new EnchantmentSoulbound(plugin)};
        List hardcodedEnchantments = CollectionsKt.listOf((Object[])hardcodedEcoEnchantArray);
        for (HardcodedEcoEnchant enchantment : hardcodedEnchantments) {
            if (!enchantment.isPresent() || this.getRegistry().get(enchantment.getId()) != null) continue;
            this.doRegister(plugin, enchantment);
        }
    }

    @Nullable
    public final EcoEnchant getByName(@Nullable String name) {
        return name == null ? null : (EcoEnchant)BY_NAME.get((Object)name);
    }
}

