/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.util.NumberUtils;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/willfp/ecoenchants/enchant/LoreConversion;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "aggressiveLoreConverter", "", "event", "Lorg/bukkit/event/inventory/InventoryOpenEvent;", "convertLore", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "loreConverter", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nLoreConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoreConversion.kt\ncom/willfp/ecoenchants/enchant/LoreConversion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,115:1\n107#2:116\n79#2,22:117\n*S KotlinDebug\n*F\n+ 1 LoreConversion.kt\ncom/willfp/ecoenchants/enchant/LoreConversion\n*L\n81#1:116\n81#1:117,22\n*E\n"})
public final class LoreConversion
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public LoreConversion(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void loreConverter(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.plugin.getConfigYml().getBool("lore-conversion.enabled")) {
            return;
        }
        this.convertLore(event.getPlayer().getInventory().getItem(event.getNewSlot()));
    }

    @EventHandler
    public final void aggressiveLoreConverter(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.plugin.getConfigYml().getBool("lore-conversion.enabled")) {
            return;
        }
        if (!this.plugin.getConfigYml().getBool("lore-conversion.aggressive")) {
            return;
        }
        Inventory inventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
        Inventory inventory2 = inventory;
        if (!(inventory2.getHolder() instanceof BlockInventoryHolder)) {
            return;
        }
        ItemStack[] itemStackArray = inventory2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        for (ItemStack itemStack : itemStackArray) {
            this.convertLore(itemStack);
        }
    }

    private final void convertLore(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        Map toAdd = new LinkedHashMap();
        List list = FastItemStackExtensions.fast((ItemStack)itemStack).getLore();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLore(...)");
        List lore = CollectionsKt.toMutableList((Collection)list);
        for (String entry : CollectionsKt.toList((Iterable)lore)) {
            String uncolored;
            if (ChatColor.stripColor((String)entry) == null) continue;
            EcoEnchant enchant = null;
            int level = 0;
            String[] stringArray = new String[]{" "};
            List split = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)uncolored, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (split.isEmpty()) continue;
            if (split.size() == 1) {
                enchant = EcoEnchants.INSTANCE.getByName((String)split.get(0));
                level = 1;
            } else {
                EcoEnchant attemptFullLine = EcoEnchants.INSTANCE.getByName(entry);
                if (attemptFullLine != null) {
                    enchant = attemptFullLine;
                    level = 1;
                } else {
                    int $this$trim$iv22;
                    String levelString = (String)CollectionsKt.last((List)split);
                    split.remove(levelString);
                    String $this$trim$iv22 = levelString;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv22;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    levelString = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    try {
                        $this$trim$iv22 = NumberUtils.fromNumeral((String)levelString);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    level = $this$trim$iv22;
                    String enchantName = CollectionsKt.joinToString$default((Iterable)split, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                    enchant = EcoEnchants.INSTANCE.getByName(enchantName);
                }
            }
            if (enchant == null) continue;
            Integer n = level;
            toAdd.put(enchant.getEnchantment(), n);
        }
        if (meta instanceof EnchantmentStorageMeta) {
            lore.clear();
            for (Map.Entry entry : toAdd.entrySet()) {
                enchant = (Enchantment)entry.getKey();
                int level = ((Number)entry.getValue()).intValue();
                ((EnchantmentStorageMeta)meta).addStoredEnchant(enchant, level, true);
            }
        } else {
            lore.clear();
            for (Map.Entry entry : toAdd.entrySet()) {
                enchant = (Enchantment)entry.getKey();
                int level = ((Number)entry.getValue()).intValue();
                meta.addEnchant(enchant, level, true);
            }
        }
        itemStack.setItemMeta(meta);
        FastItemStackExtensions.fast((ItemStack)itemStack).setLore(lore);
    }
}

