/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.mechanics;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.core.proxy.ProxyConstants;
import com.willfp.eco.util.StringUtils;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.enchant.UtilKt;
import com.willfp.ecoenchants.mechanics.AnvilResult;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.ecoenchants.mechanics.OpenInventoryProxy;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/willfp/ecoenchants/mechanics/AnvilSupport;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "antiRepeat", "", "Ljava/util/UUID;", "anvilGuiClass", "", "doMerge", "Lcom/willfp/ecoenchants/mechanics/AnvilResult;", "left", "Lorg/bukkit/inventory/ItemStack;", "right", "itemName", "player", "Lorg/bukkit/entity/Player;", "onAnvilPrepare", "", "event", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nAnvilSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnvilSupport.kt\ncom/willfp/ecoenchants/mechanics/AnvilSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1#2:407\n*E\n"})
public final class AnvilSupport
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final Set<UUID> antiRepeat;
    @NotNull
    private final String anvilGuiClass;

    public AnvilSupport(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        this.antiRepeat = new LinkedHashSet();
        String string = ProxyConstants.NMS_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NMS_VERSION");
        String string2 = string;
        int n = 1;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        this.anvilGuiClass = "net.wesjd.anvilgui.version.Wrapper" + string3 + "$AnvilContainer";
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onAnvilPrepare(@NotNull PrepareAnvilEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = event.getViewers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
        Object object = CollectionsKt.getOrNull((List)list, (int)0);
        Player player = object instanceof Player ? (Player)object : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (Intrinsics.areEqual((Object)((OpenInventoryProxy)this.plugin.getProxy(OpenInventoryProxy.class)).getOpenInventory(player2).getClass().toString(), (Object)this.anvilGuiClass)) {
            return;
        }
        if (this.antiRepeat.contains(player2.getUniqueId())) {
            return;
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        this.antiRepeat.add(uUID);
        this.plugin.getScheduler().run(() -> AnvilSupport.onAnvilPrepare$lambda$0(this, player2, event));
    }

    /*
     * WARNING - void declaration
     */
    private final AnvilResult doMerge(ItemStack left, ItemStack right, String itemName, Player player) {
        void it;
        if (left == null || left.getType() == Material.AIR) {
            return AnvilSupportKt.access$getFAIL$p();
        }
        String it2 = player.hasPermission("ecoenchants.anvil.color") ? StringUtils.format((String)itemName) : ChatColor.stripColor((String)itemName);
        boolean bl22 = false;
        CharSequence charSequence = it2;
        String formattedItemName = charSequence == null || charSequence.length() == 0 ? FastItemStackExtensions.fast((ItemStack)left).getDisplayName() : it2;
        EcoEnchant permanenceCurse = (EcoEnchant)EcoEnchants.INSTANCE.getByID("permanence_curse");
        if (permanenceCurse != null && FastItemStackExtensions.fast((ItemStack)left).getEnchants(true).containsKey(permanenceCurse.getEnchantment())) {
            return AnvilSupportKt.access$getFAIL$p();
        }
        if (right == null || right.getType() == Material.AIR) {
            void it3;
            if (Intrinsics.areEqual((Object)FastItemStackExtensions.fast((ItemStack)left).getDisplayName(), (Object)formattedItemName)) {
                return AnvilSupportKt.access$getFAIL$p();
            }
            String bl22 = formattedItemName;
            FastItemStack fastItemStack = FastItemStackExtensions.fast((ItemStack)left);
            boolean bl3 = false;
            fastItemStack.setDisplayName("\u00a7o" + (String)it3);
            return new AnvilResult(left, 0);
        }
        ItemMeta leftMeta = left.getItemMeta();
        ItemMeta rightMeta = right.getItemMeta();
        int unitRepairCost = 0;
        if (left.getType() != right.getType()) {
            Material material = right.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material material2 = left.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material2, (String)"getType(...)");
            if (AnvilSupportKt.canUnitRepair(material, material2) && leftMeta instanceof Damageable) {
                int toDeduct;
                int perUnit = (int)Math.ceil((double)left.getType().getMaxDurability() / 4.0);
                int max = (int)Math.ceil((double)((Damageable)leftMeta).getDamage() / (double)perUnit);
                unitRepairCost = toDeduct = Math.min(max, right.getAmount());
                if (toDeduct <= 0) {
                    return AnvilSupportKt.access$getFAIL$p();
                }
                Damageable damageable = (Damageable)leftMeta;
                damageable.setDamage(damageable.getDamage() - toDeduct * perUnit);
                right.setAmount(right.getAmount() - toDeduct);
            } else if (right.getType() != Material.ENCHANTED_BOOK) {
                return AnvilSupportKt.access$getFAIL$p();
            }
        }
        String max = formattedItemName;
        FastItemStack fastItemStack = FastItemStackExtensions.fast((ItemStack)left);
        boolean bl4 = false;
        fastItemStack.setDisplayName("\u00a7o" + (String)it);
        Map map = FastItemStackExtensions.fast((ItemStack)left).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
        Map leftEnchants = map;
        Map map2 = FastItemStackExtensions.fast((ItemStack)right).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnchants(...)");
        Map rightEnchants = map2;
        Map outEnchants = MapsKt.toMutableMap((Map)leftEnchants);
        for (Map.Entry entry : rightEnchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            if (outEnchants.containsKey(enchant)) {
                int n;
                Object v = outEnchants.get(enchant);
                Intrinsics.checkNotNull(v);
                int currentLevel = ((Number)v).intValue();
                Map map3 = outEnchants;
                Integer n2 = level;
                int n3 = currentLevel;
                if (n2 != null && n2 == n3) {
                    n = Math.min(enchant.getMaxLevel(), level + 1);
                } else {
                    Intrinsics.checkNotNull((Object)level);
                    n = Math.max(level, currentLevel);
                }
                Integer n4 = n;
                map3.put(enchant, n4);
                continue;
            }
            Intrinsics.checkNotNull((Object)enchant);
            if (!UtilKt.wrap(enchant).canEnchantItem(left) || outEnchants.size() >= AnvilSupportKt.infiniteIfNegative(this.plugin.getConfigYml().getInt("anvil.enchant-limit"))) continue;
            outEnchants.put(enchant, level);
        }
        if (leftMeta instanceof Damageable && rightMeta instanceof Damageable && unitRepairCost == 0 && !(rightMeta instanceof EnchantmentStorageMeta)) {
            short maxDamage = left.getType().getMaxDurability();
            int n = maxDamage - ((Damageable)leftMeta).getDamage();
            int rightDurability = maxDamage - ((Damageable)rightMeta).getDamage();
            int damage = maxDamage - Math.max(maxDamage, n + rightDurability);
            ((Damageable)leftMeta).setDamage(damage);
        }
        if (leftMeta instanceof EnchantmentStorageMeta) {
            for (Enchantment enchantment : CollectionsKt.toSet((Iterable)((EnchantmentStorageMeta)leftMeta).getStoredEnchants().keySet())) {
                ((EnchantmentStorageMeta)leftMeta).removeStoredEnchant(enchantment);
            }
            for (Map.Entry entry : outEnchants.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                Integer level = (Integer)entry.getValue();
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)leftMeta;
                Intrinsics.checkNotNull((Object)level);
                enchantmentStorageMeta.addStoredEnchant(enchant, level.intValue(), true);
            }
        } else {
            for (Enchantment enchantment : CollectionsKt.toSet((Iterable)leftMeta.getEnchants().keySet())) {
                leftMeta.removeEnchant(enchantment);
            }
            for (Map.Entry entry : outEnchants.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                Integer level = (Integer)entry.getValue();
                Intrinsics.checkNotNull((Object)level);
                leftMeta.addEnchant(enchant, level.intValue(), true);
            }
        }
        left.setItemMeta(leftMeta);
        int enchantLevelDiff = Math.abs(CollectionsKt.sumOfInt((Iterable)leftEnchants.values()) - CollectionsKt.sumOfInt((Iterable)outEnchants.values()));
        double d = Math.pow(this.plugin.getConfigYml().getDouble("anvil.cost-exponent"), enchantLevelDiff) * (double)enchantLevelDiff + (double)unitRepairCost;
        return new AnvilResult(left, MathKt.roundToInt((double)d));
    }

    private static final void onAnvilPrepare$lambda$0(AnvilSupport this$0, Player $player, PrepareAnvilEvent $event) {
        Map map;
        ItemStack left;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        this$0.antiRepeat.remove($player.getUniqueId());
        ItemStack itemStack = $event.getInventory().getItem(0);
        ItemStack itemStack2 = left = itemStack != null ? itemStack.clone() : null;
        ItemStack old = itemStack2 != null ? itemStack2.clone() : null;
        ItemStack itemStack3 = $event.getInventory().getItem(1);
        ItemStack right = itemStack3 != null ? itemStack3.clone() : null;
        $event.setResult(null);
        $event.getInventory().setItem(2, null);
        String string = $event.getInventory().getRenameText();
        if (string == null) {
            string = "";
        }
        AnvilResult result = this$0.doMerge(left, right, string, $player);
        Integer n = result.getXp();
        int price = n != null ? n : 0;
        ItemStack itemStack4 = result.getResult();
        if (itemStack4 == null) {
            itemStack4 = new ItemStack(Material.AIR);
        }
        ItemStack outItem = itemStack4;
        int oldCost = $event.getInventory().getRepairCost();
        ItemStack oldLeft = $event.getInventory().getItem(0);
        if (Intrinsics.areEqual((Object)result, (Object)AnvilSupportKt.access$getFAIL$p())) {
            return;
        }
        if (oldLeft == null || oldLeft.getType() != outItem.getType()) {
            return;
        }
        if (Intrinsics.areEqual((Object)left, (Object)old)) {
            return;
        }
        int cost = oldCost + price;
        if (oldCost == -price) {
            cost = price;
        }
        if (cost <= 0) {
            return;
        }
        ItemStack itemStack5 = left;
        if ((itemStack5 != null && (itemStack5 = FastItemStackExtensions.fast((ItemStack)itemStack5)) != null ? itemStack5.getEnchants(true) : (map = null)) == null) {
            map = MapsKt.emptyMap();
        }
        Map leftEnchants = map;
        Map map2 = FastItemStackExtensions.fast((ItemStack)outItem).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnchants(...)");
        Map outEnchants = map2;
        if ($event.getInventory().getItem(1) == null && !Intrinsics.areEqual((Object)leftEnchants, (Object)outEnchants)) {
            return;
        }
        if (this$0.plugin.getConfigYml().getBool("anvil.use-rework-penalty")) {
            int repairCost = FastItemStackExtensions.fast((ItemStack)outItem).getRepairCost();
            FastItemStackExtensions.fast((ItemStack)outItem).setRepairCost((repairCost + 1) * 2 - 1);
        }
        $event.getInventory().setMaximumRepairCost(AnvilSupportKt.infiniteIfNegative(this$0.plugin.getConfigYml().getInt("anvil.max-repair-cost")));
        $event.getInventory().setRepairCost(cost);
        $event.setResult(outItem);
        $event.getInventory().setItem(2, outItem);
    }
}

