/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.mechanics;

import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.util.NumberUtils;
import com.willfp.eco.util.NumberUtilsExtensions;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.enchant.UtilKt;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.ecoenchants.mechanics.EnchantingTableChanceGenerateEvent;
import com.willfp.ecoenchants.mechanics.ExtraItemSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/ecoenchants/mechanics/EnchantingTableSupport;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "handleExtraItem", "", "event", "Lorg/bukkit/event/enchantment/PrepareItemEnchantEvent;", "onEnchant", "Lorg/bukkit/event/enchantment/EnchantItemEvent;", "onLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nEnchantingTableSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantingTableSupport.kt\ncom/willfp/ecoenchants/mechanics/EnchantingTableSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,248:1\n1747#2,3:249\n800#2,11:255\n1774#2,4:266\n1747#2,3:270\n187#3,3:252\n*S KotlinDebug\n*F\n+ 1 EnchantingTableSupport.kt\ncom/willfp/ecoenchants/mechanics/EnchantingTableSupport\n*L\n48#1:249,3\n122#1:255,11\n123#1:266,4\n178#1:270,3\n117#1:252,3\n*E\n"})
public final class EnchantingTableSupport
implements Listener {
    @NotNull
    private final EcoEnchantsPlugin plugin;

    public EnchantingTableSupport(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ExtraItemSupport.INSTANCE.getCurrentlyEnchantingExtraItem$core_plugin().remove(event.getPlayer().getUniqueId());
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onEnchant(@NotNull EnchantItemEvent event) {
        boolean isExtraEnchantable;
        Map toAdd;
        int cost;
        ItemStack item;
        Player player;
        block20: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player2 = event.getEnchanter();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEnchanter(...)");
            player = player2;
            ItemStack itemStack = event.getItem().clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
            item = itemStack;
            cost = event.getExpLevelCost();
            Map map = event.getEnchantsToAdd();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantsToAdd(...)");
            toAdd = map;
            if (!this.plugin.getConfigYml().getBool("enchanting-table.enabled")) {
                return;
            }
            Iterable $this$any$iv = ExtraItemSupport.INSTANCE.getExtraEnchantableItems$core_plugin();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestableItem it = (TestableItem)element$iv;
                    boolean bl = false;
                    if (!it.matches(item)) continue;
                    v3 = true;
                    break block20;
                }
                v3 = isExtraEnchantable = false;
            }
        }
        if (isExtraEnchantable) {
            ItemStack lapis = event.getInventory().getItem(1);
            if (player.getGameMode() != GameMode.CREATIVE) {
                if (lapis == null) {
                    event.setCancelled(true);
                    return;
                }
                int lapisCost = event.whichButton() + 1;
                if (lapis.getAmount() < lapisCost) {
                    event.setCancelled(true);
                    return;
                }
                lapis.setAmount(lapis.getAmount() - lapisCost);
                event.getInventory().setItem(1, lapis);
            }
        }
        if (item.getType() == Material.BOOK) {
            item.setType(Material.ENCHANTED_BOOK);
        }
        double multiplier = 0.01;
        if (item.getType() == Material.ENCHANTED_BOOK) {
            multiplier *= this.plugin.getConfigYml().getDouble("enchanting-table.book-multiplier");
        }
        List enchantments = CollectionsKt.shuffled((Iterable)EcoEnchants.INSTANCE.values());
        for (EcoEnchant enchantment : enchantments) {
            int n;
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object object;
            boolean bl;
            block21: {
                if (!enchantment.isObtainableThroughEnchanting() || !enchantment.canEnchantItem(item) || !player.hasPermission("ecoenchants.fromtable." + enchantment.getId())) continue;
                double baseChance = enchantment.getEnchantmentRarity().getTableChance() * multiplier;
                EnchantingTableChanceGenerateEvent chanceEvent = new EnchantingTableChanceGenerateEvent(player, item, enchantment.getEnchantment(), baseChance);
                Bukkit.getPluginManager().callEvent((Event)chanceEvent);
                if (NumberUtils.randFloat((double)0.0, (double)1.0) > chanceEvent.getChance() || enchantment.getEnchantmentRarity().getMinimumLevel() > cost) continue;
                if (toAdd.size() >= this.plugin.getConfigYml().getInt("enchanting-table.cap") || toAdd.size() > AnvilSupportKt.infiniteIfNegative(this.plugin.getConfigYml().getInt("anvil.enchant-limit"))) break;
                Map $this$any$iv = toAdd;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = object.next();
                        boolean bl2 = false;
                        Enchantment it = (Enchantment)entry.getKey();
                        Enchantment enchantment2 = enchantment.getEnchantment();
                        Intrinsics.checkNotNull((Object)it);
                        if (!UtilKt.conflictsWithDeep(enchantment2, it)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            Iterable $this$filterIsInstance$iv = toAdd.keySet();
            boolean $i$f$filterIsInstance = false;
            object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EcoEnchant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    EcoEnchant it = (EcoEnchant)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)enchantment.getType()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n >= enchantment.getType().getLimit()) continue;
            int maxLevel = enchantment.getMaximumLevel();
            int maxObtainableLevel = this.plugin.getConfigYml().getInt("enchanting-table.maximum-obtainable-level");
            double levelPart1 = enchantment.getType().getHighLevelBias() > 0.0 ? NumberUtilsExtensions.randDouble((double)0.0, (double)1.0) : (double)cost / (double)maxObtainableLevel;
            double levelPart2 = NumberUtils.bias((double)levelPart1, (double)enchantment.getType().getHighLevelBias());
            double levelPart3 = NumberUtils.triangularDistribution((double)0.0, (double)1.0, (double)levelPart2);
            int level = (int)((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(Math.ceil(levelPart3 * (double)maxLevel)), (ClosedFloatingPointRange)RangesKt.rangeTo((double)1.0, (double)maxLevel)))).doubleValue();
            multiplier /= this.plugin.getConfigYml().getDouble("enchanting-table.reduction");
            Integer n2 = level;
            toAdd.put(enchantment.getEnchantment(), n2);
        }
        Map map = event.getEnchantsToAdd();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantsToAdd(...)");
        toAdd.forEach((arg_0, arg_1) -> EnchantingTableSupport.onEnchant$lambda$3((Function2)new Function2<Enchantment, Integer, Unit>((Object)map){

            public final void invoke(Enchantment p0, Integer p1) {
                ((Map)this.receiver).putIfAbsent(p0, p1);
            }
        }, arg_0, arg_1));
        if (toAdd.isEmpty() && isExtraEnchantable) {
            Integer[] integerArray = ExtraItemSupport.INSTANCE.getCurrentlyEnchantingExtraItem$core_plugin().get(player.getUniqueId());
            Intrinsics.checkNotNull((Object)integerArray);
            toAdd.put(Enchantment.DURABILITY, integerArray[event.whichButton()]);
            ExtraItemSupport.INSTANCE.getCurrentlyEnchantingExtraItem$core_plugin().remove(player.getUniqueId());
        }
        if (item.getType() == Material.ENCHANTED_BOOK) {
            this.plugin.getScheduler().run(() -> EnchantingTableSupport.onEnchant$lambda$4(event));
        }
    }

    @EventHandler
    public final void handleExtraItem(@NotNull PrepareItemEnchantEvent event) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.plugin.getConfigYml().getBool("enchanting-table.enabled")) {
                return;
            }
            ItemStack itemStack = event.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            ItemStack item = itemStack;
            Iterable $this$any$iv = ExtraItemSupport.INSTANCE.getExtraEnchantableItems$core_plugin();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestableItem it = (TestableItem)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(item)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        int maxObtainableLevel = this.plugin.getConfigYml().getInt("enchanting-table.maximum-obtainable-level");
        EnchantmentOffer[] enchantmentOfferArray = event.getOffers();
        Intrinsics.checkNotNullExpressionValue((Object)enchantmentOfferArray, (String)"getOffers(...)");
        EnchantmentOffer enchantmentOffer = (EnchantmentOffer)ArraysKt.getOrNull((Object[])enchantmentOfferArray, (int)2);
        if (enchantmentOffer != null) {
            EnchantmentOffer enchantmentOffer2 = event.getOffers()[2];
            enchantmentOffer.setCost(Math.min(enchantmentOffer2 != null ? enchantmentOffer2.getCost() : 0, maxObtainableLevel));
        }
        int bonus = RangesKt.coerceIn((int)event.getEnchantmentBonus(), (ClosedRange)((ClosedRange)new IntRange(1, 15)));
        double baseLevel = (double)NumberUtils.randInt((int)1, (int)8) + Math.floor((double)bonus / 2.0) + (double)NumberUtils.randInt((int)0, (int)bonus);
        int levelScale = (int)Math.ceil((double)maxObtainableLevel / 30.0);
        int bottomEnchantLevel = RangesKt.coerceAtMost((int)((int)Math.ceil(RangesKt.coerceAtLeast((double)(baseLevel / (double)3), (double)1.0)) * levelScale), (int)maxObtainableLevel);
        int midEnchantLevel = ((int)(baseLevel * (double)2 / (double)3) + 1) * levelScale;
        int topEnchantLevel = (int)RangesKt.coerceAtLeast((double)baseLevel, (double)((double)bonus * 2.0)) * levelScale;
        int midUnbreakingLevel = NumberUtils.randInt((int)1, (int)3);
        if (midUnbreakingLevel < 2) {
            midUnbreakingLevel = 2;
        }
        if (midEnchantLevel < 15) {
            midUnbreakingLevel = 1;
        }
        int topUnbreakingLevel = 3;
        if (topEnchantLevel < 20) {
            topUnbreakingLevel = 2;
        }
        if (topEnchantLevel < 10) {
            topUnbreakingLevel = 1;
        }
        EnchantmentOffer[] enchantmentOfferArray2 = new EnchantmentOffer[]{new EnchantmentOffer(Enchantment.DURABILITY, 1, bottomEnchantLevel), new EnchantmentOffer(Enchantment.DURABILITY, midUnbreakingLevel, midEnchantLevel), new EnchantmentOffer(Enchantment.DURABILITY, topUnbreakingLevel, topEnchantLevel)};
        for (EnchantmentOffer event.getOffers()[i] : enchantmentOfferArray2) {
        }
        Map<UUID, Integer[]> map = ExtraItemSupport.INSTANCE.getCurrentlyEnchantingExtraItem$core_plugin();
        UUID uUID = event.getEnchanter().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uUID2 = uUID;
        Integer[] integerArray = new Integer[3];
        EnchantmentOffer enchantmentOffer3 = event.getOffers()[0];
        integerArray[0] = enchantmentOffer3 != null ? enchantmentOffer3.getEnchantmentLevel() : 0;
        EnchantmentOffer enchantmentOffer4 = event.getOffers()[1];
        integerArray[1] = enchantmentOffer4 != null ? enchantmentOffer4.getEnchantmentLevel() : 0;
        EnchantmentOffer enchantmentOffer5 = event.getOffers()[2];
        integerArray[2] = enchantmentOffer5 != null ? enchantmentOffer5.getEnchantmentLevel() : 0;
        map.put(uUID2, integerArray);
    }

    private static final void onEnchant$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void onEnchant$lambda$4(EnchantItemEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        if (!$event.isCancelled()) {
            ItemStack postEnchantItem;
            ItemStack itemStack = postEnchantItem = $event.getInventory().getItem(0);
            Object object = itemStack != null ? itemStack.getItemMeta() : null;
            EnchantmentStorageMeta meta = object instanceof EnchantmentStorageMeta ? (EnchantmentStorageMeta)object : null;
            Map map = $event.getEnchantsToAdd();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchantsToAdd(...)");
            for (Map.Entry entry : map.entrySet()) {
                Enchantment enchant = (Enchantment)entry.getKey();
                Integer level = (Integer)entry.getValue();
                EnchantmentStorageMeta enchantmentStorageMeta = meta;
                if (enchantmentStorageMeta == null) continue;
                Intrinsics.checkNotNull((Object)level);
                enchantmentStorageMeta.addStoredEnchant(enchant, level.intValue(), true);
            }
            ItemStack itemStack2 = postEnchantItem;
            if (itemStack2 != null) {
                itemStack2.setItemMeta((ItemMeta)meta);
            }
        }
    }
}

