/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.mechanics;

import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.util.NumberUtils;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.enchant.UtilKt;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.ecoenchants.target.EnchantmentTargets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/willfp/ecoenchants/mechanics/LootSupport;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "modifyItem", "", "item", "Lorg/bukkit/inventory/ItemStack;", "onGenerate", "event", "Lorg/bukkit/event/world/LootGenerateEvent;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nLootSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootSupport.kt\ncom/willfp/ecoenchants/mechanics/LootSupport\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n187#2,3:96\n215#2,2:114\n215#2,2:116\n800#3,11:99\n1774#3,4:110\n*S KotlinDebug\n*F\n+ 1 LootSupport.kt\ncom/willfp/ecoenchants/mechanics/LootSupport\n*L\n60#1:96,3\n88#1:114,2\n90#1:116,2\n69#1:99,11\n70#1:110,4\n*E\n"})
public final class LootSupport
implements Listener {
    @NotNull
    private final EcoEnchantsPlugin plugin;

    public LootSupport(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onGenerate(@NotNull LootGenerateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.plugin.getConfigYml().getBool("loot.enabled")) {
            return;
        }
        for (ItemStack itemStack : event.getLoot()) {
            Intrinsics.checkNotNull((Object)itemStack);
            this.modifyItem(itemStack);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void modifyItem(ItemStack item) {
        ItemMeta meta;
        if (!EnchantmentTargets.INSTANCE.isEnchantable(item)) {
            return;
        }
        Map map = FastItemStackExtensions.fast((ItemStack)item).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnchants(...)");
        Map enchants = map;
        double multiplier = 0.01;
        if (item.getType() == Material.ENCHANTED_BOOK) {
            multiplier *= this.plugin.getConfigYml().getDouble("loot.book-multiplier");
        }
        List enchantments = CollectionsKt.shuffled((Iterable)EcoEnchants.INSTANCE.values());
        for (EcoEnchant enchantment : enchantments) {
            int n;
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object object;
            boolean bl;
            block14: {
                if (!enchantment.isObtainableThroughDiscovery() || !enchantment.canEnchantItem(item) || NumberUtils.randFloat((double)0.0, (double)1.0) > enchantment.getEnchantmentRarity().getLootChance() * multiplier) continue;
                Map $this$any$iv = enchants;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    object = $this$any$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = object.next();
                        boolean bl2 = false;
                        Enchantment it = (Enchantment)entry.getKey();
                        Enchantment enchantment2 = enchantment.getEnchantment();
                        Intrinsics.checkNotNull((Object)it);
                        if (!UtilKt.conflictsWithDeep(enchantment2, it)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            if (enchants.size() > AnvilSupportKt.infiniteIfNegative(this.plugin.getConfigYml().getInt("anvil.enchant-limit"))) break;
            Iterable $this$filterIsInstance$iv = enchants.keySet();
            boolean $i$f$filterIsInstance = false;
            object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof EcoEnchant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    EcoEnchant it = (EcoEnchant)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)enchantment.getType()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n >= enchantment.getType().getLimit()) continue;
            int maxLevel = enchantment.getMaximumLevel();
            double levelPart1 = NumberUtils.bias((double)NumberUtils.randFloat((double)0.7, (double)1.0), (double)enchantment.getType().getHighLevelBias());
            double levelPart2 = NumberUtils.triangularDistribution((double)0.0, (double)1.0, (double)levelPart1);
            int level = (int)((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(Math.ceil(levelPart2 * (double)maxLevel)), (ClosedFloatingPointRange)RangesKt.rangeTo((double)1.0, (double)maxLevel)))).doubleValue();
            multiplier /= this.plugin.getConfigYml().getDouble("villager.reduction");
            Integer n2 = level;
            enchants.put(enchantment.getEnchantment(), n2);
        }
        if ((meta = item.getItemMeta()) instanceof EnchantmentStorageMeta) {
            $this$forEach$iv = enchants;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                var11_17 = element$iv = iterator.next();
                boolean bl = false;
                Enchantment enchant = (Enchantment)var11_17.getKey();
                level = (Integer)var11_17.getValue();
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
                Intrinsics.checkNotNull((Object)level);
                enchantmentStorageMeta.addStoredEnchant(enchant, level.intValue(), true);
            }
        } else {
            $this$forEach$iv = enchants;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                var11_17 = element$iv = iterator.next();
                boolean bl = false;
                Enchantment enchant = (Enchantment)var11_17.getKey();
                level = (Integer)var11_17.getValue();
                Intrinsics.checkNotNull((Object)level);
                meta.addEnchant(enchant, level.intValue(), true);
            }
        }
        item.setItemMeta(meta);
    }
}

