/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.type;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.registry.Registrable;
import com.willfp.ecoenchants.libreforge.TriggerEnchantType;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import com.willfp.libreforge.triggers.Triggers;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/willfp/ecoenchants/type/EnchantmentType;", "Lcom/willfp/eco/core/registry/Registrable;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "config", "Lcom/willfp/eco/core/config/interfaces/Config;", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/eco/core/config/interfaces/Config;)V", "getConfig$core_plugin", "()Lcom/willfp/eco/core/config/interfaces/Config;", "format", "", "Lorg/jetbrains/annotations/NotNull;", "getFormat", "()Ljava/lang/String;", "highLevelBias", "", "getHighLevelBias", "()D", "id", "getId", "limit", "", "getLimit", "()I", "noGrindstone", "", "getNoGrindstone", "()Z", "equals", "other", "", "getID", "hashCode", "onRegister", "", "toString", "core-plugin"})
public final class EnchantmentType
implements Registrable {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final Config config;
    @NotNull
    private final String id;
    @NotNull
    private final String format;
    private final int limit;
    private final double highLevelBias;
    private final boolean noGrindstone;

    public EnchantmentType(@NotNull EcoPlugin plugin, @NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.plugin = plugin;
        this.config = config2;
        String string = this.config.getString("id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.id = string;
        String string2 = this.config.getString("format");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.format = string2;
        this.limit = AnvilSupportKt.infiniteIfNegative(this.config.getInt("limit"));
        this.highLevelBias = this.config.getDouble("high-level-bias");
        this.noGrindstone = this.config.getBool("no-grindstone");
    }

    @NotNull
    public final Config getConfig$core_plugin() {
        return this.config;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final double getHighLevelBias() {
        return this.highLevelBias;
    }

    public final boolean getNoGrindstone() {
        return this.noGrindstone;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnchantmentType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((EnchantmentType)other).id, (Object)this.id);
    }

    public void onRegister() {
        Triggers.INSTANCE.register((Registrable)new TriggerEnchantType(this.plugin, this));
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.id};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "EnchantmentType{" + this.id + "}";
    }
}

