/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.command;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.command.CommandExecutor;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.extension.Extension;

public interface Command {
    public @NonNull String name();

    public @NonNull String description();

    public @NonNull String permission();

    public @NonNull List<String> aliases();

    public boolean isSuggestedOpOnly();

    public boolean isExecutableOnConsole();

    default public @NonNull List<String> subCommands() {
        return Collections.emptyList();
    }

    default public boolean isBedrockOnly() {
        return false;
    }

    public static <T extends CommandSource> Builder<T> builder(@NonNull Extension extension) {
        return (Builder)GeyserApi.api().provider(Builder.class, extension);
    }

    public static interface Builder<T extends CommandSource> {
        public Builder<T> source(@NonNull Class<? extends T> var1);

        public Builder<T> name(@NonNull String var1);

        public Builder<T> description(@NonNull String var1);

        public Builder<T> permission(@NonNull String var1);

        public Builder<T> aliases(@NonNull List<String> var1);

        public Builder<T> suggestedOpOnly(boolean var1);

        public Builder<T> executableOnConsole(boolean var1);

        public Builder<T> subCommands(@NonNull List<String> var1);

        public Builder<T> bedrockOnly(boolean var1);

        public Builder<T> executor(@NonNull CommandExecutor<T> var1);

        public @NonNull Command build();
    }
}

