/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.event.java;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.connection.ConnectionEvent;

public class ServerTransferEvent
extends ConnectionEvent {
    private final String host;
    private final int port;
    private String bedrockHost;
    private int bedrockPort;
    private final Map<String, byte[]> cookies;

    public ServerTransferEvent(@NonNull GeyserConnection connection, @NonNull String host, int port, @NonNull Map<String, byte[]> cookies) {
        super(connection);
        this.host = host;
        this.port = port;
        this.cookies = cookies;
        this.bedrockHost = null;
        this.bedrockPort = -1;
    }

    public @NonNull String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public @Nullable String bedrockHost() {
        return this.bedrockHost;
    }

    public int bedrockPort() {
        return this.bedrockPort;
    }

    public void bedrockHost(@NonNull String host) {
        if (host == null || host.isBlank()) {
            throw new IllegalArgumentException("Server address cannot be null or blank");
        }
        this.bedrockHost = host;
    }

    public void bedrockPort(@IntRange(from=0L, to=65535L) int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Server port must be between 0 and 65535, was " + port);
        }
        this.bedrockPort = port;
    }

    public @NonNull Map<String, byte[]> cookies() {
        return this.cookies;
    }
}

