/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.SpawnEggItem;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class MobEntity
extends LivingEntity {
    private long leashHolderBedrockId;

    public MobEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setLeashHolderBedrockId(-1L);
    }

    public void setMobFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.NO_AI, (xd & 1) == 1);
    }

    public void setLeashHolderBedrockId(long bedrockId) {
        this.leashHolderBedrockId = bedrockId;
        this.dirtyMetadata.put(EntityDataTypes.LEASH_HOLDER, bedrockId);
    }

    @Override
    protected final InteractiveTag testInteraction(Hand hand) {
        InteractionResult result;
        if (!this.isAlive()) {
            return InteractiveTag.NONE;
        }
        if (this.leashHolderBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractiveTag.REMOVE_LEASH;
        }
        GeyserItemStack itemStack = this.session.getPlayerInventory().getItemInHand(hand);
        if (itemStack.asItem() == Items.LEAD && this.canBeLeashed()) {
            return InteractiveTag.LEASH;
        }
        if (itemStack.asItem() == Items.NAME_TAG && (result = this.checkInteractWithNameTag(itemStack)).consumesAction()) {
            return InteractiveTag.NAME;
        }
        InteractiveTag tag = this.testMobInteraction(hand, itemStack);
        return tag != InteractiveTag.NONE ? tag : super.testInteraction(hand);
    }

    @Override
    public final InteractionResult interact(Hand hand) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        if (this.leashHolderBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractionResult.SUCCESS;
        }
        GeyserItemStack itemInHand = this.session.getPlayerInventory().getItemInHand(hand);
        InteractionResult result = this.checkPriorityInteractions(itemInHand);
        if (result.consumesAction()) {
            return result;
        }
        InteractionResult mobResult = this.mobInteract(hand, itemInHand);
        return mobResult.consumesAction() ? mobResult : super.interact(hand);
    }

    private InteractionResult checkPriorityInteractions(GeyserItemStack itemInHand) {
        if (itemInHand.asItem() == Items.LEAD && this.canBeLeashed()) {
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.asItem() == Items.NAME_TAG) {
            InteractionResult result = this.checkInteractWithNameTag(itemInHand);
            if (result.consumesAction()) {
                return result;
            }
        } else if (itemInHand.asItem() instanceof SpawnEggItem) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        return InteractiveTag.NONE;
    }

    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        return InteractionResult.PASS;
    }

    protected boolean canBeLeashed() {
        return this.isNotLeashed() && !this.isEnemy();
    }

    protected final boolean isNotLeashed() {
        return this.leashHolderBedrockId == -1L;
    }

    protected boolean isEnemy() {
        return false;
    }

    public long getLeashHolderBedrockId() {
        return this.leashHolderBedrockId;
    }
}

