/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.tameable;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.tameable.TameableEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class CatEntity
extends TameableEntity {
    private byte collarColor = (byte)14;

    public CatEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, 1);
    }

    @Override
    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(0.0, 0.0, 0.0, yaw, pitch, yaw, isOnGround);
    }

    @Override
    protected float getAdultSize() {
        return 0.8f;
    }

    @Override
    protected float getBabySize() {
        return 0.4f;
    }

    @Override
    public void setTameableFlags(ByteEntityMetadata entityMetadata) {
        super.setTameableFlags(entityMetadata);
        this.updateCollarColor();
    }

    public void setCatVariant(IntEntityMetadata entityMetadata) {
        int metadataValue = entityMetadata.getPrimitiveValue();
        int variantColor = switch (metadataValue) {
            case 0 -> 8;
            case 8 -> 0;
            case 9 -> 10;
            case 10 -> 9;
            default -> metadataValue;
        };
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, variantColor);
    }

    public void setResting(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.RESTING, entityMetadata.getPrimitiveValue());
    }

    public void setCollarColor(IntEntityMetadata entityMetadata) {
        this.collarColor = (byte)entityMetadata.getPrimitiveValue();
        this.updateCollarColor();
    }

    private void updateCollarColor() {
        if (this.getFlag(EntityFlag.TAMED)) {
            this.dirtyMetadata.put(EntityDataTypes.COLOR, this.collarColor);
        }
    }

    @Override
    protected @Nullable ItemTag getFoodTag() {
        return ItemTag.CAT_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tamed = this.getFlag(EntityFlag.TAMED);
        if (tamed && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return this.getFlag(EntityFlag.SITTING) ? InteractiveTag.STAND : InteractiveTag.SIT;
        }
        return !this.canEat(itemInHand) || this.health >= this.maxHealth && tamed ? InteractiveTag.NONE : InteractiveTag.FEED;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean tamed = this.getFlag(EntityFlag.TAMED);
        if (tamed && this.ownerBedrockId == this.session.getPlayerEntity().getGeyserId()) {
            return InteractionResult.SUCCESS;
        }
        return !this.canEat(itemInHand) || this.health >= this.maxHealth && tamed ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }
}

