/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class ZoglinEntity
extends MonsterEntity {
    public ZoglinEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setBaby(BooleanEntityMetadata entityMetadata) {
        boolean isBaby = entityMetadata.getPrimitiveValue();
        if (isBaby != this.getFlag(EntityFlag.BABY)) {
            this.setScale(isBaby ? 0.55f : 1.0f);
            this.setFlag(EntityFlag.BABY, isBaby);
            this.updatePassengerOffsets();
        }
    }

    @Override
    public float getBoundingBoxHeight() {
        float scale = this.getFlag(EntityFlag.BABY) ? 0.55f : 1.0f;
        return scale * this.definition.height();
    }

    @Override
    protected boolean canBeLeashed() {
        return this.isNotLeashed();
    }

    @Override
    protected boolean isEnemy() {
        return true;
    }
}

