/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public enum Potion {
    WATER(0),
    MUNDANE(1),
    THICK(3),
    AWKWARD(4),
    NIGHT_VISION(5),
    LONG_NIGHT_VISION(6),
    INVISIBILITY(7),
    LONG_INVISIBILITY(8),
    LEAPING(9),
    LONG_LEAPING(10),
    STRONG_LEAPING(11),
    FIRE_RESISTANCE(12),
    LONG_FIRE_RESISTANCE(13),
    SWIFTNESS(14),
    LONG_SWIFTNESS(15),
    STRONG_SWIFTNESS(16),
    SLOWNESS(17),
    LONG_SLOWNESS(18),
    STRONG_SLOWNESS(42),
    TURTLE_MASTER(37),
    LONG_TURTLE_MASTER(38),
    STRONG_TURTLE_MASTER(39),
    WATER_BREATHING(19),
    LONG_WATER_BREATHING(20),
    HEALING(21),
    STRONG_HEALING(22),
    HARMING(23),
    STRONG_HARMING(24),
    POISON(25),
    LONG_POISON(26),
    STRONG_POISON(27),
    REGENERATION(28),
    LONG_REGENERATION(29),
    STRONG_REGENERATION(30),
    STRENGTH(31),
    LONG_STRENGTH(32),
    STRONG_STRENGTH(33),
    WEAKNESS(34),
    LONG_WEAKNESS(35),
    LUCK(2),
    SLOW_FALLING(40),
    LONG_SLOW_FALLING(41);

    public static final Potion[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);
    private final short bedrockId;

    private Potion(int bedrockId) {
        this.bedrockId = (short)bedrockId;
    }

    public PotionContents toComponent() {
        return new PotionContents(this.ordinal(), -1, Int2ObjectMaps.emptyMap());
    }

    public static @Nullable Potion getByJavaId(int javaId) {
        if (javaId >= 0 && javaId < VALUES.length) {
            return VALUES[javaId];
        }
        return null;
    }

    public static @Nullable Potion getByBedrockId(int bedrockId) {
        for (Potion potion : VALUES) {
            if (potion.bedrockId != bedrockId) continue;
            return potion;
        }
        return null;
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public short getBedrockId() {
        return this.bedrockId;
    }

    static {
        VALUES = Potion.values();
    }
}

