/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.auth.data.GameProfile;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class PlayerHeadItem
extends Item {
    public PlayerHeadItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        GameProfile profile;
        super.translateComponentsToBedrock(session, components, builder);
        String customName = builder.getCustomName();
        if (customName == null && (profile = components.get(DataComponentType.PROFILE)) != null) {
            String name = profile.getName();
            if (name != null) {
                String displayName = "\u00a7r\u00a7e" + MinecraftLocale.getLocaleString("block.minecraft.player_head.named", session.locale()).replace("%s", name);
                builder.setCustomName(displayName);
            } else {
                builder.setCustomName("\u00a7r\u00a7e" + MinecraftLocale.getLocaleString("block.minecraft.player_head", session.locale()));
            }
        }
    }
}

