/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import com.viaversion.viaversion.bukkit.handlers.BukkitChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.network.netty.GeyserInjector;
import org.geysermc.geyser.network.netty.LocalServerChannelWrapper;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.platform.spigot.GeyserSpigotCompressionDisabler;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;

public class GeyserSpigotInjector
extends GeyserInjector {
    private final boolean isViaVersion;
    private List<ChannelFuture> allServerChannels;

    public GeyserSpigotInjector(boolean isViaVersion) {
        this.isViaVersion = isViaVersion;
    }

    @Override
    protected void initializeLocalChannel0(final GeyserBootstrap bootstrap) throws Exception {
        Class<?> serverClazz;
        try {
            serverClazz = Class.forName("net.minecraft.server.MinecraftServer");
        }
        catch (ClassNotFoundException e) {
            String prefix = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "net.minecraft.server");
            serverClazz = Class.forName(prefix + ".MinecraftServer");
        }
        Method getServer = serverClazz.getDeclaredMethod("getServer", new Class[0]);
        Object server = getServer.invoke(null, new Object[0]);
        Object connection = null;
        for (Method m : serverClazz.getDeclaredMethods()) {
            if (!m.getReturnType().getSimpleName().equals("ServerConnection") && !m.getReturnType().getSimpleName().equals("ServerConnectionListener") || m.getParameterTypes().length != 0) continue;
            connection = m.invoke(server, new Object[0]);
        }
        if (connection == null) {
            throw new RuntimeException("Unable to find ServerConnection class!");
        }
        ChannelFuture listeningChannel = null;
        for (Field field : connection.getClass().getDeclaredFields()) {
            ChannelFuture o;
            boolean rightList;
            if (field.getType() != List.class) continue;
            field.setAccessible(true);
            boolean bl = rightList = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] == ChannelFuture.class;
            if (!rightList) continue;
            this.allServerChannels = (List)field.get(connection);
            Iterator<ChannelFuture> iterator = this.allServerChannels.iterator();
            if (!iterator.hasNext()) continue;
            listeningChannel = o = iterator.next();
        }
        if (listeningChannel == null) {
            throw new RuntimeException("Unable to find listening channel!");
        }
        final ChannelInitializer<Channel> childHandler = this.getChildHandler(bootstrap, listeningChannel);
        final Method initChannel = childHandler.getClass().getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) throws Exception {
                String baseName;
                initChannel.invoke((Object)childHandler, ch);
                int index = ch.pipeline().names().indexOf("encoder");
                String string = baseName = index != -1 ? "encoder" : "outbound_config";
                if (bootstrap.getGeyserConfig().isDisableCompression() && GeyserSpigotCompressionDisabler.ENABLED) {
                    ch.pipeline().addAfter(baseName, "geyser-compression-disabler", (ChannelHandler)new GeyserSpigotCompressionDisabler());
                }
            }
        }).group((EventLoopGroup)new DefaultEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("Geyser Spigot connection thread", 10))).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.allServerChannels.add(channelFuture);
        this.localChannel = channelFuture;
        this.serverSocketAddress = channelFuture.channel().localAddress();
        this.workAroundWeirdBug(bootstrap);
    }

    private ChannelInitializer<Channel> getChildHandler(GeyserBootstrap bootstrap, ChannelFuture listeningChannel) {
        List names = listeningChannel.channel().pipeline().names();
        ChannelInitializer childHandler = null;
        for (String name : names) {
            ChannelHandler handler = listeningChannel.channel().pipeline().get(name);
            try {
                Field childHandlerField = handler.getClass().getDeclaredField("childHandler");
                childHandlerField.setAccessible(true);
                childHandler = (ChannelInitializer)childHandlerField.get(handler);
                if (!this.isViaVersion || !(childHandler instanceof BukkitChannelInitializer)) break;
                childHandler = ((BukkitChannelInitializer)childHandler).original();
                break;
            }
            catch (Exception e) {
                if (!bootstrap.getGeyserConfig().isDebugMode()) continue;
                bootstrap.getGeyserLogger().debug("The handler " + name + " isn't a ChannelInitializer. THIS ERROR IS SAFE TO IGNORE!");
                e.printStackTrace();
            }
        }
        if (childHandler == null) {
            throw new RuntimeException();
        }
        return childHandler;
    }

    private void workAroundWeirdBug(GeyserBootstrap bootstrap) {
        MinecraftProtocol protocol = new MinecraftProtocol();
        LocalSession session = new LocalSession(bootstrap.getGeyserConfig().getRemote().address(), bootstrap.getGeyserConfig().getRemote().port(), this.serverSocketAddress, InetAddress.getLoopbackAddress().getHostAddress(), protocol, protocol.createHelper());
        session.connect();
        session.disconnect("");
    }

    @Override
    public void shutdown() {
        if (this.allServerChannels != null) {
            this.allServerChannels.remove(this.localChannel);
            this.allServerChannels = null;
        }
        super.shutdown();
    }
}

